/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog.impl;

import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.service.ServiceExecutor;
import io.atomix.primitive.service.impl.DefaultServiceExecutor;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.service.RaftServiceContext;
import io.atomix.utils.concurrent.SingleThreadContext;
import io.atomix.utils.concurrent.ThreadContext;
import io.zeebe.distributedlog.DistributedLogstreamClient;
import io.zeebe.distributedlog.DistributedLogstreamService;
import io.zeebe.distributedlog.DistributedLogstreamType;
import io.zeebe.distributedlog.StorageConfiguration;
import io.zeebe.distributedlog.impl.DistributedLogstreamServiceConfig;
import io.zeebe.distributedlog.impl.LogstreamConfig;
import io.zeebe.distributedlog.restore.RestoreClient;
import io.zeebe.distributedlog.restore.RestoreFactory;
import io.zeebe.distributedlog.restore.RestoreNodeProvider;
import io.zeebe.distributedlog.restore.impl.RestoreController;
import io.zeebe.distributedlog.restore.log.LogReplicationAppender;
import io.zeebe.distributedlog.restore.log.LogReplicator;
import io.zeebe.distributedlog.restore.snapshot.RestoreSnapshotReplicator;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreContext;
import io.zeebe.logstreams.LogStreams;
import io.zeebe.logstreams.impl.service.LogStreamServiceNames;
import io.zeebe.logstreams.log.BufferedLogStreamReader;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.spi.LogStorage;
import io.zeebe.logstreams.state.FileSnapshotConsumer;
import io.zeebe.logstreams.state.StateStorage;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.util.ZbLogger;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDistributedLogstreamService
extends AbstractPrimitiveService<DistributedLogstreamClient>
implements DistributedLogstreamService,
LogReplicationAppender {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDistributedLogstreamService.class);
    private LogStream logStream;
    private LogStorage logStorage;
    private String logName;
    private int partitionId;
    private String currentLeader;
    private long currentLeaderTerm = -1L;
    private long lastPosition = -1L;
    private ServiceContainer serviceContainer;
    private String localMemberId;
    private Logger logger;

    public DefaultDistributedLogstreamService(DistributedLogstreamServiceConfig config) {
        super(DistributedLogstreamType.instance(), DistributedLogstreamClient.class);
    }

    protected void configure(ServiceExecutor executor) {
        super.configure(executor);
        this.localMemberId = (String)((Object)this.getLocalMemberId().id());
        try {
            this.logName = this.getRaftPartitionName(executor);
            this.configureFromLogName(this.logName);
            this.logger.info("Configuring {} on node {} with logName {}", new Object[]{this.getServiceName(), this.getLocalMemberId().id(), this.logName});
            this.logStream = this.getOrCreateLogStream(this.logName);
            this.logStorage = this.logStream.getLogStorage();
            this.initLastPosition();
            this.logger.info("Configured with LogStream {} and last appended event at position {}", (Object)this.logName, (Object)this.lastPosition);
        }
        catch (Exception e) {
            LOG.error("Failed to configure {} on node {} with logName {}", new Object[]{this.getServiceName(), this.getLocalMemberId().id(), this.logName, e});
            throw e;
        }
    }

    private void configureFromLogName(String logName) {
        this.partitionId = this.getPartitionIdFromLogName(logName);
        this.logger = new ZbLogger(String.format("%s-%d", this.getClass().getName(), this.partitionId));
    }

    private int getPartitionIdFromLogName(String logName) {
        String[] parts = logName.split("-");
        return Integer.valueOf(parts[parts.length - 1]);
    }

    private String getRaftPartitionName(ServiceExecutor executor) {
        String name;
        try {
            Field context = DefaultServiceExecutor.class.getDeclaredField("context");
            context.setAccessible(true);
            RaftServiceContext raftServiceContext = (RaftServiceContext)context.get(executor);
            Field raft = RaftServiceContext.class.getDeclaredField("raft");
            raft.setAccessible(true);
            RaftContext raftContext = (RaftContext)raft.get(raftServiceContext);
            name = raftContext.getName();
            raft.setAccessible(false);
            context.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return name;
    }

    private LogStream getOrCreateLogStream(String logServiceName) {
        this.serviceContainer = LogstreamConfig.getServiceContainer(this.localMemberId);
        LogStream logStream = this.serviceContainer.hasService(LogStreamServiceNames.logStreamServiceName(logServiceName)) ? LogstreamConfig.getLogStream(this.localMemberId, this.partitionId) : this.createLogStream(logServiceName);
        LogstreamConfig.putLogStream(this.localMemberId, this.partitionId, logStream);
        return logStream;
    }

    private LogStream createLogStream(String logServiceName) {
        StorageConfiguration config = (StorageConfiguration)LogstreamConfig.getConfig(this.localMemberId, this.partitionId).join();
        File logDirectory = config.getLogDirectory();
        File snapshotDirectory = config.getSnapshotsDirectory();
        File blockIndexDirectory = config.getBlockIndexDirectory();
        StateStorage stateStorage = new StateStorage(blockIndexDirectory, snapshotDirectory);
        return (LogStream)LogStreams.createFsLogStream(this.partitionId).logDirectory(logDirectory.getAbsolutePath()).logSegmentSize((int)config.getLogSegmentSize()).indexBlockSize((int)config.getIndexBlockSize()).logName(logServiceName).serviceContainer(this.serviceContainer).indexStateStorage(stateStorage).build().join();
    }

    private void initLastPosition() {
        BufferedLogStreamReader reader = new BufferedLogStreamReader(this.logStream);
        reader.seekToLastEvent();
        this.lastPosition = reader.getPosition();
        if (this.lastPosition > 0L) {
            this.logStream.setCommitPosition(this.lastPosition);
        }
        reader.close();
    }

    @Override
    public long append(String nodeId, long commitPosition, byte[] blockBuffer) {
        if (!this.currentLeader.equals(nodeId)) {
            this.logger.warn("Append request from follower node {}. Current leader is {}.", (Object)nodeId, (Object)this.currentLeader);
            return 0L;
        }
        return this.append(commitPosition, blockBuffer);
    }

    @Override
    public long append(long commitPosition, byte[] blockBuffer) {
        if (commitPosition <= this.lastPosition) {
            this.logger.trace("Rejecting append request at position {}", (Object)commitPosition);
            return 1L;
        }
        ByteBuffer buffer = ByteBuffer.wrap(blockBuffer);
        long appendResult = this.logStorage.append(buffer);
        if (appendResult > 0L) {
            this.updateCommitPosition(commitPosition);
        } else {
            this.logger.error("Append failed {}", (Object)appendResult);
        }
        return appendResult;
    }

    @Override
    public boolean claimLeaderShip(String nodeId, long term) {
        this.logger.debug("Node {} claiming leadership for LogStream partition {} at term {}.", new Object[]{nodeId, this.logStream.getPartitionId(), term});
        if (this.currentLeaderTerm < term) {
            this.currentLeader = nodeId;
            this.currentLeaderTerm = term;
            return true;
        }
        return false;
    }

    public void backup(BackupOutput backupOutput) {
        this.logger.info("Backup log {} at position {}", (Object)this.logName, (Object)this.lastPosition);
        backupOutput.writeLong(this.lastPosition);
        backupOutput.writeString(this.currentLeader);
        backupOutput.writeLong(this.currentLeaderTerm);
    }

    public void restore(BackupInput backupInput) {
        long backupPosition = backupInput.readLong();
        if (this.lastPosition < backupPosition) {
            LogstreamConfig.startRestore(this.localMemberId, this.partitionId);
            SingleThreadContext restoreThreadContext = new SingleThreadContext(String.format("log-restore-%d", this.partitionId));
            RestoreController restoreController = this.createRestoreController((ThreadContext)restoreThreadContext);
            while (this.lastPosition < backupPosition) {
                long latestLocalPosition = this.lastPosition;
                this.logger.trace("Restoring local log from position {} to {}", (Object)latestLocalPosition, (Object)backupPosition);
                try {
                    this.lastPosition = restoreController.restore(this.lastPosition, backupPosition);
                    this.logger.trace("Restored local log from position {} to {}", (Object)latestLocalPosition, (Object)this.lastPosition);
                }
                catch (RuntimeException e) {
                    this.lastPosition = this.logStream.getCommitPosition();
                    this.logger.debug("Restoring local log failed at position {}. Retrying.", (Object)this.lastPosition, (Object)e);
                }
            }
            restoreThreadContext.close();
            LogstreamConfig.completeRestore(this.localMemberId, this.partitionId);
        }
        this.logger.debug("Restored local log to position {}", (Object)this.lastPosition);
        this.currentLeader = backupInput.readString();
        this.currentLeaderTerm = backupInput.readLong();
    }

    private RestoreController createRestoreController(ThreadContext restoreThreadContext) {
        RestoreFactory restoreFactory = LogstreamConfig.getRestoreFactory(this.localMemberId);
        RestoreClient restoreClient = restoreFactory.createClient(this.partitionId);
        RestoreNodeProvider nodeProvider = restoreFactory.createNodeProvider(this.partitionId);
        LogReplicator logReplicator = new LogReplicator(this, restoreClient, (Executor)restoreThreadContext);
        SnapshotRestoreContext snapshotRestoreContext = restoreFactory.createSnapshotRestoreContext(this.partitionId, this.logger);
        StateStorage storage = snapshotRestoreContext.getStateStorage();
        FileSnapshotConsumer snapshotConsumer = new FileSnapshotConsumer(storage, LOG);
        RestoreSnapshotReplicator snapshotReplicator = new RestoreSnapshotReplicator(restoreClient, snapshotRestoreContext, snapshotConsumer, (Executor)restoreThreadContext, this.logger);
        return new RestoreController(restoreClient, nodeProvider, logReplicator, snapshotReplicator, restoreThreadContext, this.logger);
    }

    private void updateCommitPosition(long commitPosition) {
        this.logStream.setCommitPosition(commitPosition);
        this.lastPosition = commitPosition;
    }

    public void close() {
        super.close();
        this.logger.info("Closing {}", (Object)this.getServiceName());
    }
}

