/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog.restore.impl;

import io.zeebe.distributedlog.restore.RestoreInfoRequest;
import io.zeebe.distributedlog.restore.RestoreInfoResponse;
import io.zeebe.distributedlog.restore.RestoreServer;
import io.zeebe.distributedlog.restore.impl.DefaultRestoreInfoResponse;
import io.zeebe.distributedlog.restore.snapshot.impl.DefaultSnapshotRestoreInfo;
import io.zeebe.logstreams.log.BufferedLogStreamReader;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.logstreams.spi.SnapshotController;
import java.io.File;

public class DefaultRestoreInfoRequestHandler
implements RestoreServer.RestoreInfoRequestHandler {
    private final SnapshotController snapshotController;
    private final LogStreamReader reader;

    public DefaultRestoreInfoRequestHandler(LogStream logStream, SnapshotController snapshotController) {
        this.reader = new BufferedLogStreamReader(logStream);
        this.snapshotController = snapshotController;
    }

    @Override
    public RestoreInfoResponse onRestoreInfoRequest(RestoreInfoRequest request) {
        long lastValidSnapshotPosition = this.snapshotController.getLastValidSnapshotPosition();
        if (lastValidSnapshotPosition > -1L && lastValidSnapshotPosition >= request.getLatestLocalPosition()) {
            RestoreInfoResponse.ReplicationTarget target = RestoreInfoResponse.ReplicationTarget.SNAPSHOT;
            File lastValidSnapshotDirectory = this.snapshotController.getLastValidSnapshotDirectory();
            int numChunks = lastValidSnapshotDirectory.listFiles().length;
            return new DefaultRestoreInfoResponse(target, new DefaultSnapshotRestoreInfo(lastValidSnapshotPosition, numChunks));
        }
        RestoreInfoResponse.ReplicationTarget target = this.seekToRequestedPositionExclusive(request.getLatestLocalPosition()) ? RestoreInfoResponse.ReplicationTarget.EVENTS : RestoreInfoResponse.ReplicationTarget.NONE;
        return new DefaultRestoreInfoResponse(target);
    }

    private boolean seekToRequestedPositionExclusive(long position) {
        if (position == -1L) {
            this.reader.seekToFirstEvent();
            return this.reader.hasNext();
        }
        return this.reader.seek(position) && this.reader.hasNext();
    }
}

