/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog.restore.impl;

import io.zeebe.distributedlog.restore.RestoreInfoResponse;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreInfo;
import io.zeebe.distributedlog.restore.snapshot.impl.DefaultSnapshotRestoreInfo;

public class DefaultRestoreInfoResponse
implements RestoreInfoResponse {
    private RestoreInfoResponse.ReplicationTarget replicationTarget;
    private SnapshotRestoreInfo snapshotRestoreInfo;
    private static final NullSnapshotRestoreInfo NULL_SNAPSHOT_RESTORE_INFO = new NullSnapshotRestoreInfo();

    public DefaultRestoreInfoResponse() {
        this.snapshotRestoreInfo = NULL_SNAPSHOT_RESTORE_INFO;
    }

    public DefaultRestoreInfoResponse(RestoreInfoResponse.ReplicationTarget replicationTarget) {
        this();
        this.replicationTarget = replicationTarget;
    }

    public DefaultRestoreInfoResponse(RestoreInfoResponse.ReplicationTarget replicationTarget, SnapshotRestoreInfo snapshotRestoreInfo) {
        this.replicationTarget = replicationTarget;
        this.snapshotRestoreInfo = snapshotRestoreInfo;
    }

    @Override
    public RestoreInfoResponse.ReplicationTarget getReplicationTarget() {
        return this.replicationTarget;
    }

    @Override
    public SnapshotRestoreInfo getSnapshotRestoreInfo() {
        return this.snapshotRestoreInfo;
    }

    public void setReplicationTarget(RestoreInfoResponse.ReplicationTarget replicationTarget) {
        this.replicationTarget = replicationTarget;
    }

    public void setSnapshotRestoreInfo(SnapshotRestoreInfo snapshotRestoreInfo) {
        this.snapshotRestoreInfo = snapshotRestoreInfo;
    }

    public void setSnapshotRestoreInfo(long snapshotId, int numChunks) {
        if (snapshotId > 0L) {
            this.setSnapshotRestoreInfo(new DefaultSnapshotRestoreInfo(snapshotId, numChunks));
        } else {
            this.setSnapshotRestoreInfo(NULL_SNAPSHOT_RESTORE_INFO);
        }
    }

    private static class NullSnapshotRestoreInfo
    implements SnapshotRestoreInfo {
        private NullSnapshotRestoreInfo() {
        }

        @Override
        public long getSnapshotId() {
            return -1L;
        }

        @Override
        public int getNumChunks() {
            return -1;
        }
    }
}

