/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog.restore.impl;

import io.atomix.cluster.MemberId;
import io.atomix.utils.concurrent.ThreadContext;
import io.zeebe.distributedlog.restore.RestoreClient;
import io.zeebe.distributedlog.restore.RestoreInfoResponse;
import io.zeebe.distributedlog.restore.RestoreNodeProvider;
import io.zeebe.distributedlog.restore.RestoreStrategy;
import io.zeebe.distributedlog.restore.impl.DefaultRestoreInfoRequest;
import io.zeebe.distributedlog.restore.log.LogReplicator;
import io.zeebe.distributedlog.restore.snapshot.RestoreSnapshotReplicator;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreStrategy;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public class RestoreController {
    private final ThreadContext restoreThreadContext;
    private final Logger logger;
    private final RestoreClient restoreClient;
    private final RestoreNodeProvider nodeProvider;
    private final LogReplicator logReplicator;
    private final RestoreSnapshotReplicator snapshotReplicator;

    public RestoreController(RestoreClient restoreClient, RestoreNodeProvider nodeProvider, LogReplicator logReplicator, RestoreSnapshotReplicator snapshotReplicator, ThreadContext restoreThreadContext, Logger log) {
        this.restoreClient = restoreClient;
        this.nodeProvider = nodeProvider;
        this.logReplicator = logReplicator;
        this.snapshotReplicator = snapshotReplicator;
        this.restoreThreadContext = restoreThreadContext;
        this.logger = log;
    }

    public long restore(long latestLocalPosition, long backupPosition) {
        return (Long)((CompletableFuture)((CompletableFuture)this.findRestoreServer().thenCompose(server -> this.findRestoreStrategy((MemberId)server, latestLocalPosition, backupPosition))).thenCompose(RestoreStrategy::executeRestoreStrategy)).join();
    }

    private CompletableFuture<MemberId> findRestoreServer() {
        CompletableFuture<MemberId> result = new CompletableFuture<MemberId>();
        this.tryFindRestoreServer(result);
        return result;
    }

    private void tryFindRestoreServer(CompletableFuture<MemberId> result) {
        MemberId server = this.nodeProvider.provideRestoreNode();
        if (server != null) {
            result.complete(server);
        } else {
            this.restoreThreadContext.schedule(Duration.ofMillis(100L), () -> this.tryFindRestoreServer(result));
        }
    }

    private CompletableFuture<RestoreStrategy> findRestoreStrategy(MemberId server, long latestLocalPosition, long backupPosition) {
        DefaultRestoreInfoRequest request = new DefaultRestoreInfoRequest(latestLocalPosition, backupPosition);
        return this.restoreClient.requestRestoreInfo(server, request).thenCompose(response -> this.onRestoreInfoReceived(server, latestLocalPosition, backupPosition, (RestoreInfoResponse)response));
    }

    private CompletableFuture<RestoreStrategy> onRestoreInfoReceived(MemberId server, long latestLocalPosition, long backupPosition, RestoreInfoResponse response) {
        CompletableFuture<RestoreStrategy> result = new CompletableFuture<RestoreStrategy>();
        switch (response.getReplicationTarget()) {
            case SNAPSHOT: {
                SnapshotRestoreStrategy snapshotRestoreStrategy = new SnapshotRestoreStrategy(this.logReplicator, this.snapshotReplicator, response.getSnapshotRestoreInfo(), latestLocalPosition, backupPosition, server, this.logger);
                result.complete(snapshotRestoreStrategy);
                break;
            }
            case EVENTS: {
                result.complete(() -> this.logReplicator.replicate(server, latestLocalPosition, backupPosition));
                break;
            }
            case NONE: {
                result.completeExceptionally(new UnsupportedOperationException("Not yet implemented"));
            }
        }
        return result;
    }
}

