/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog.restore.log.impl;

import io.zeebe.distributedlog.restore.RestoreServer;
import io.zeebe.distributedlog.restore.log.LogReplicationRequest;
import io.zeebe.distributedlog.restore.log.LogReplicationResponse;
import io.zeebe.distributedlog.restore.log.impl.DefaultLogReplicationResponse;
import io.zeebe.logstreams.log.BufferedLogStreamReader;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.util.ZbLogger;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class DefaultLogReplicationRequestHandler
implements RestoreServer.LogReplicationRequestHandler {
    private static final int DEFAULT_READ_BUFFER_SIZE = 0x4000000;
    private final LogStreamReader reader;
    private final MutableDirectBuffer readerBuffer;
    private final Logger logger;

    public DefaultLogReplicationRequestHandler(LogStream logStream) {
        this(logStream, 0x4000000);
    }

    public DefaultLogReplicationRequestHandler(LogStream logStream, int bufferSize) {
        this.reader = new BufferedLogStreamReader(logStream);
        this.readerBuffer = new UnsafeBuffer(ByteBuffer.allocate(bufferSize));
        this.logger = new ZbLogger(String.format("log.replication.server.%s", logStream.getLogName()));
    }

    @Override
    public final LogReplicationResponse onReplicationRequest(LogReplicationRequest request) {
        DefaultLogReplicationResponse response = new DefaultLogReplicationResponse();
        if (this.seekToRequestedPosition(request.getFromPosition(), !request.includeFromPosition())) {
            LoggedEvent event;
            long lastReadPosition = this.reader.getPosition();
            int offset = 0;
            while (this.reader.hasNext() && offset + (event = (LoggedEvent)this.reader.next()).getLength() <= this.readerBuffer.capacity()) {
                if (event.getPosition() > request.getToPosition()) continue;
                event.write(this.readerBuffer, offset);
                offset += event.getLength();
                lastReadPosition = event.getPosition();
            }
            response.setToPosition(lastReadPosition);
            response.setMoreAvailable(lastReadPosition < request.getToPosition() && this.reader.hasNext());
            response.setSerializedEvents((DirectBuffer)this.readerBuffer, 0, offset);
        } else {
            this.logger.debug("Ignoring log replication request {} - {}, no events found with position {}", new Object[]{request.getFromPosition(), request.getToPosition(), request.getFromPosition()});
        }
        return response;
    }

    private boolean seekToRequestedPosition(long position, boolean skipEventAtPosition) {
        if (position == -1L) {
            this.reader.seekToFirstEvent();
            return true;
        }
        if (this.reader.seek(position) && this.reader.hasNext()) {
            if (skipEventAtPosition) {
                this.reader.next();
            }
            return true;
        }
        return false;
    }
}

