/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog.restore.snapshot;

import io.atomix.cluster.MemberId;
import io.zeebe.distributedlog.restore.RestoreClient;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreContext;
import io.zeebe.distributedlog.restore.snapshot.impl.DefaultSnapshotRestoreRequest;
import io.zeebe.logstreams.state.SnapshotConsumer;
import io.zeebe.util.ZbLogger;
import io.zeebe.util.collection.Tuple;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;

public class RestoreSnapshotReplicator {
    private final RestoreClient client;
    private final SnapshotRestoreContext restoreContext;
    private SnapshotConsumer snapshotConsumer;
    private final Executor executor;
    private final Logger logger;
    private int numChunks;

    public RestoreSnapshotReplicator(RestoreClient client, SnapshotRestoreContext restoreContext, SnapshotConsumer snapshotConsumer, Executor executor, Logger logger) {
        this.client = client;
        this.restoreContext = restoreContext;
        this.snapshotConsumer = snapshotConsumer;
        this.executor = executor;
        this.logger = logger;
    }

    public RestoreSnapshotReplicator(RestoreClient client, SnapshotRestoreContext restoreContext, SnapshotConsumer snapshotConsumer, Executor executor) {
        this(client, restoreContext, snapshotConsumer, executor, (Logger)new ZbLogger(RestoreSnapshotReplicator.class));
    }

    public CompletableFuture<Tuple<Long, Long>> restore(MemberId server, long snapshotId, int numChunks) {
        this.numChunks = numChunks;
        CompletableFuture<Tuple<Long, Long>> result = new CompletableFuture<Tuple<Long, Long>>();
        this.restoreInternal(server, snapshotId, 0, result);
        return result;
    }

    private void restoreInternal(MemberId server, long snapshotId, int chunkIdx, CompletableFuture<Tuple<Long, Long>> future) {
        DefaultSnapshotRestoreRequest request = new DefaultSnapshotRestoreRequest(snapshotId, chunkIdx);
        this.client.requestSnapshotChunk(server, request).whenCompleteAsync((r, e) -> {
            if (e != null) {
                this.failReplication(snapshotId, future, (Throwable)e);
                return;
            }
            if (!r.isSuccess()) {
                this.failReplication(snapshotId, future, new RuntimeException(String.format("Could not restore snapshot %d. Received an invalid response for request %d from server %s", snapshotId, request.getChunkIdx(), server.id())));
                return;
            }
            if (!this.snapshotConsumer.consumeSnapshotChunk(r.getSnapshotChunk())) {
                this.failReplication(snapshotId, future, new RuntimeException(String.format("Could not restore snapshot %d. Failed to consume snapshot chunk %d", snapshotId, request.getChunkIdx())));
                return;
            }
            if (chunkIdx + 1 < this.numChunks) {
                this.restoreInternal(server, snapshotId, chunkIdx + 1, future);
                return;
            }
            if (this.snapshotConsumer.completeSnapshot(snapshotId)) {
                Tuple<Long, Long> positions = this.restoreContext.getSnapshotPositionSupplier().get();
                future.complete(positions);
            } else {
                this.failReplication(snapshotId, future, new RuntimeException(String.format("Could not restore snapshot %d. Failed to move valid snapshot.", snapshotId)));
            }
        }, this.executor);
    }

    private void failReplication(long snapshotId, CompletableFuture future, Throwable error) {
        future.completeExceptionally(error);
        this.logger.debug("Snapshot restore failed {}", (Object)snapshotId, (Object)error);
        this.snapshotConsumer.invalidateSnapshot(snapshotId);
    }
}

