/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog.restore.snapshot;

import io.atomix.cluster.MemberId;
import io.zeebe.distributedlog.restore.RestoreStrategy;
import io.zeebe.distributedlog.restore.log.LogReplicator;
import io.zeebe.distributedlog.restore.snapshot.RestoreSnapshotReplicator;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreInfo;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public class SnapshotRestoreStrategy
implements RestoreStrategy {
    private final MemberId server;
    private final LogReplicator logReplicator;
    private final Logger log;
    private final long backupPosition;
    private final SnapshotRestoreInfo snapshotRestoreInfo;
    private final long latestLocalPosition;
    private RestoreSnapshotReplicator replicator;

    public SnapshotRestoreStrategy(LogReplicator logReplicator, RestoreSnapshotReplicator replicator, SnapshotRestoreInfo snapshotRestoreInfo, long latestLocalPosition, long backupPosition, MemberId server, Logger log) {
        this.logReplicator = logReplicator;
        this.replicator = replicator;
        this.snapshotRestoreInfo = snapshotRestoreInfo;
        this.latestLocalPosition = latestLocalPosition;
        this.backupPosition = backupPosition;
        this.server = server;
        this.log = log;
    }

    @Override
    public CompletableFuture<Long> executeRestoreStrategy() {
        return this.replicator.restore(this.server, this.snapshotRestoreInfo.getSnapshotId(), this.snapshotRestoreInfo.getNumChunks()).thenCompose(tuple -> this.onSnapshotsReplicated((Long)tuple.getLeft(), (Long)tuple.getRight()));
    }

    private CompletableFuture<Long> onSnapshotsReplicated(long exporterPosition, long processedPosition) {
        long fromPosition = Math.max(this.latestLocalPosition, this.getFirstEventToBeReplicated(exporterPosition, processedPosition));
        long toPosition = Math.max(processedPosition, this.backupPosition);
        this.log.debug("Restored snapshot. Restoring events from {} to {}", (Object)fromPosition, (Object)toPosition);
        return this.logReplicator.replicate(this.server, fromPosition, toPosition, fromPosition > this.latestLocalPosition);
    }

    private long getFirstEventToBeReplicated(long exporterPosition, long processedPosition) {
        return Math.min(processedPosition, exporterPosition);
    }
}

