/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.distributedlog.restore.snapshot.impl;

import io.zeebe.distributedlog.restore.RestoreServer;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreRequest;
import io.zeebe.distributedlog.restore.snapshot.SnapshotRestoreResponse;
import io.zeebe.distributedlog.restore.snapshot.impl.InvalidSnapshotRestoreResponse;
import io.zeebe.distributedlog.restore.snapshot.impl.SuccessSnapshotRestoreResponse;
import io.zeebe.logstreams.impl.Loggers;
import io.zeebe.logstreams.spi.SnapshotController;
import io.zeebe.logstreams.state.SnapshotChunk;
import io.zeebe.logstreams.state.SnapshotChunkUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;

public class DefaultSnapshotRequestHandler
implements RestoreServer.SnapshotRequestHandler {
    private static final Logger LOG = Loggers.PROCESSOR_LOGGER;
    private final SnapshotController snapshotController;

    public DefaultSnapshotRequestHandler(SnapshotController snapshotStorage) {
        this.snapshotController = snapshotStorage;
    }

    @Override
    public SnapshotRestoreResponse onSnapshotRequest(SnapshotRestoreRequest request) {
        LOG.debug("Replicating snapshot on demand");
        File snapshotDirectory = this.snapshotController.getSnapshotDirectoryFor(request.getSnapshotId());
        if (snapshotDirectory.exists()) {
            Object[] files = snapshotDirectory.listFiles();
            Arrays.sort(files);
            if (request.getChunkIdx() < files.length) {
                Object chunkFile = files[request.getChunkIdx()];
                try {
                    SnapshotChunk snapshotChunk = SnapshotChunkUtil.createSnapshotChunkFromFile((File)chunkFile, request.getSnapshotId(), files.length);
                    return new SuccessSnapshotRestoreResponse(snapshotChunk);
                }
                catch (IOException e) {
                    LOG.warn("Unexpected error when reading snapshot chunk file {} ({}) at index {}.", new Object[]{((File)chunkFile).toString(), request.getSnapshotId(), request.getChunkIdx(), e});
                }
            }
        }
        return new InvalidSnapshotRestoreResponse();
    }
}

