/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl;

import io.zeebe.logstreams.impl.LogEntryDescriptor;
import io.zeebe.logstreams.spi.ReadResultProcessor;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class CompleteEventsInBlockProcessor
implements ReadResultProcessor {
    private final MutableDirectBuffer directBuffer = new UnsafeBuffer(0L, 0);
    private long lastReadEventPosition = -1L;

    long getLastReadEventPosition() {
        return this.lastReadEventPosition;
    }

    @Override
    public int process(ByteBuffer byteBuffer, int readResult) {
        if (byteBuffer.capacity() < LogEntryDescriptor.HEADER_BLOCK_LENGTH) {
            readResult = -3;
        }
        this.directBuffer.wrap(byteBuffer);
        int startPosition = byteBuffer.position() - readResult;
        readResult = this.calculateCorrectReadResult(readResult, startPosition);
        if (readResult > 0) {
            byteBuffer.position(startPosition + readResult);
            byteBuffer.limit(startPosition + readResult);
        } else if (readResult == 0) {
            readResult = -3;
        }
        return readResult;
    }

    private int calculateCorrectReadResult(int readResult, int position) {
        int remainingBytes = readResult;
        while (remainingBytes >= LogEntryDescriptor.HEADER_BLOCK_LENGTH) {
            int fragmentLength = LogEntryDescriptor.getFragmentLength((DirectBuffer)this.directBuffer, position);
            if (fragmentLength <= remainingBytes) {
                this.lastReadEventPosition = LogEntryDescriptor.getPosition((DirectBuffer)this.directBuffer, position);
                remainingBytes -= fragmentLength;
                position += fragmentLength;
                continue;
            }
            readResult = fragmentLength > this.directBuffer.capacity() ? -3 : (readResult -= remainingBytes);
            remainingBytes = 0;
        }
        if (remainingBytes != 0) {
            readResult -= remainingBytes;
        }
        return readResult;
    }
}

