/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl;

import io.zeebe.logstreams.impl.CompleteEventsInBlockProcessor;
import io.zeebe.logstreams.impl.LogEntryDescriptor;
import io.zeebe.logstreams.impl.LogStreamBuilder;
import io.zeebe.logstreams.impl.Loggers;
import io.zeebe.logstreams.impl.log.index.LogBlockIndex;
import io.zeebe.logstreams.impl.log.index.LogBlockIndexContext;
import io.zeebe.logstreams.spi.LogStorage;
import io.zeebe.util.allocation.AllocatedBuffer;
import io.zeebe.util.allocation.BufferAllocators;
import io.zeebe.util.metrics.Metric;
import io.zeebe.util.metrics.MetricsManager;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorCondition;
import io.zeebe.util.sched.channel.ActorConditions;
import io.zeebe.util.sched.future.ActorFuture;
import java.nio.ByteBuffer;
import java.time.Duration;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.Position;
import org.slf4j.Logger;

public class LogBlockIndexWriter
extends Actor {
    public static final Logger LOG = Loggers.LOGSTREAMS_LOGGER;
    public static final float DEFAULT_DEVIATION = 0.1f;
    private Runnable currentRunnable;
    private final Runnable runCurrentWork = this::runCurrentWork;
    private final Runnable readLogStorage = this::readLogStorage;
    private final Runnable addCurrentBlockToIndex = this::addCurrentBlockToIndex;
    private final Runnable createSnapshot = this::createSnapshot;
    private final String name;
    private final LogStorage logStorage;
    private final LogBlockIndex blockIndex;
    private final LogBlockIndexContext indexContext;
    private final MetricsManager metricsManager;
    private final int indexBlockSize;
    private final float deviation;
    private final CompleteEventsInBlockProcessor completeEventsProcessor = new CompleteEventsInBlockProcessor();
    private long nextAddress = -1L;
    private int currentBlockSize = 0;
    private long currentBlockAddress = -1L;
    private long currentBlockEventPosition = 0L;
    private long lastBlockAddress = 0L;
    private long lastBlockEventPosition = 0L;
    private final UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);
    private int bufferSize;
    private ByteBuffer ioBuffer;
    private AllocatedBuffer allocatedBuffer;
    private final Position commitPosition;
    private final ActorConditions onCommitPositionUpdatedConditions;
    private ActorCondition onCommitCondition;
    private final Duration snapshotInterval;
    private long snapshotEventPosition = -1L;
    private Metric snapshotsCreated;

    public LogBlockIndexWriter(String name, LogStreamBuilder builder, LogStorage logStorage, LogBlockIndex blockIndex, MetricsManager metricsManager) {
        this.name = name;
        this.logStorage = logStorage;
        this.blockIndex = blockIndex;
        this.metricsManager = metricsManager;
        this.commitPosition = builder.getCommitPosition();
        this.onCommitPositionUpdatedConditions = builder.getOnCommitPositionUpdatedConditions();
        this.deviation = builder.getDeviation();
        this.indexBlockSize = (int)((float)builder.getIndexBlockSize() * (1.0f - this.deviation));
        this.snapshotInterval = builder.getSnapshotPeriod();
        this.bufferSize = builder.getReadBlockSize();
        this.allocatedBuffer = BufferAllocators.allocateDirect((int)this.bufferSize);
        this.ioBuffer = this.allocatedBuffer.getRawBuffer();
        this.buffer.wrap(this.ioBuffer);
        this.indexContext = blockIndex.createLogBlockIndexContext();
    }

    public String getName() {
        return this.name;
    }

    protected void onActorStarting() {
        this.snapshotsCreated = this.metricsManager.newMetric("logstream_blockidx_snapshots").type("counter").label("logName", this.getName()).create();
        try {
            long snapshotPosition = this.blockIndex.getLastPosition();
            long snapshotBlockAddress = this.blockIndex.lookupBlockAddress(this.indexContext, snapshotPosition);
            if (snapshotBlockAddress >= this.logStorage.getFirstBlockAddress()) {
                this.nextAddress = snapshotBlockAddress;
                this.lastBlockAddress = snapshotBlockAddress;
                this.lastBlockEventPosition = snapshotPosition;
                this.snapshotEventPosition = snapshotPosition;
            } else {
                LOG.warn("Can't find address of snapshot position. Rebuilding block index.");
            }
            if (this.nextAddress == -1L) {
                this.nextAddress = this.logStorage.getFirstBlockAddress();
                this.lastBlockAddress = 0L;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to recover block index", (Throwable)e);
            throw new RuntimeException("Failed to recover block index", e);
        }
    }

    protected void onActorStarted() {
        this.onCommitCondition = this.actor.onCondition("log-index-on-commit", this.runCurrentWork);
        this.onCommitPositionUpdatedConditions.registerConsumer(this.onCommitCondition);
        this.actor.runAtFixedRate(this.snapshotInterval, this.createSnapshot);
        if (this.nextAddress > 0L) {
            this.currentRunnable = this.readLogStorage;
            this.runCurrentWork();
        } else {
            this.currentRunnable = () -> {
                this.nextAddress = this.logStorage.getFirstBlockAddress();
                this.currentRunnable = this.readLogStorage;
                this.runCurrentWork();
            };
        }
    }

    private void runCurrentWork() {
        this.actor.submit(this.currentRunnable);
    }

    private void readLogStorage() {
        this.ioBuffer.clear();
        long currentAddress = this.nextAddress;
        long result = this.logStorage.read(this.ioBuffer, currentAddress, this.completeEventsProcessor);
        if (result > currentAddress) {
            this.nextAddress = result;
            this.addToCurrentBlock(currentAddress, this.ioBuffer.position());
        } else if (result == -3L) {
            this.increaseBufferSize();
            this.runCurrentWork();
        } else if (result == -1L) {
            LOG.warn("Can't read from illegal address: {}", (Object)currentAddress);
            this.nextAddress = this.lastBlockAddress;
            this.resetCurrentBlock();
        }
    }

    private void addToCurrentBlock(long currentAddress, int readBytes) {
        if (this.currentBlockAddress == -1L) {
            this.currentBlockAddress = currentAddress;
            this.currentBlockEventPosition = LogEntryDescriptor.getPosition((DirectBuffer)this.buffer, 0);
        }
        this.currentBlockSize += readBytes;
        if (this.currentBlockSize >= this.indexBlockSize) {
            this.addCurrentBlockToIndex();
        } else {
            this.runCurrentWork();
        }
    }

    private void addCurrentBlockToIndex() {
        if (this.isCurrentBlockCommitted()) {
            if (this.currentBlockAddress > this.lastBlockAddress) {
                LOG.trace("Add block to index with position {} and address {}.", (Object)this.currentBlockEventPosition, (Object)this.currentBlockAddress);
                this.blockIndex.addBlock(this.indexContext, this.currentBlockEventPosition, this.currentBlockAddress);
                this.lastBlockAddress = this.currentBlockAddress;
                this.lastBlockEventPosition = this.currentBlockEventPosition;
            }
            this.resetCurrentBlock();
            this.currentRunnable = this.readLogStorage;
        } else {
            this.currentRunnable = this.addCurrentBlockToIndex;
        }
        this.runCurrentWork();
    }

    private boolean isCurrentBlockCommitted() {
        return this.commitPosition.getVolatile() >= this.completeEventsProcessor.getLastReadEventPosition();
    }

    private void resetCurrentBlock() {
        this.currentBlockAddress = -1L;
        this.currentBlockEventPosition = 0L;
        this.currentBlockSize = 0;
    }

    private void increaseBufferSize() {
        this.bufferSize *= 2;
        this.allocatedBuffer.close();
        this.allocatedBuffer = BufferAllocators.allocateDirect((int)this.bufferSize);
        this.ioBuffer = this.allocatedBuffer.getRawBuffer();
        this.buffer.wrap(this.ioBuffer);
    }

    private void createSnapshot() {
        try {
            if (this.lastBlockEventPosition > 0L && this.lastBlockEventPosition > this.snapshotEventPosition) {
                this.logStorage.flush();
                this.snapshotEventPosition = this.lastBlockEventPosition;
                this.blockIndex.writeSnapshot(this.snapshotEventPosition);
                LOG.trace("Created snapshot of block index {}.", (Object)this.name);
                this.snapshotsCreated.incrementOrdered();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to create snapshot of block index {}", (Object)this.name, (Object)e);
        }
    }

    public ActorFuture<Void> closeAsync() {
        return this.actor.close();
    }

    protected void onActorClosing() {
        this.resetCurrentBlock();
        this.allocatedBuffer.close();
        this.onCommitPositionUpdatedConditions.removeConsumer(this.onCommitCondition);
        this.snapshotsCreated.close();
    }

    public Metric getSnapshotsCreated() {
        return this.snapshotsCreated;
    }
}

