/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl;

import io.zeebe.logstreams.impl.LogBlockIndexWriter;
import io.zeebe.logstreams.impl.log.fs.FsLogStorage;
import io.zeebe.logstreams.impl.log.fs.FsLogStorageConfiguration;
import io.zeebe.logstreams.impl.log.index.LogBlockIndex;
import io.zeebe.logstreams.impl.service.FsLogStorageService;
import io.zeebe.logstreams.impl.service.LogBlockIndexService;
import io.zeebe.logstreams.impl.service.LogBlockIndexWriterService;
import io.zeebe.logstreams.impl.service.LogStreamService;
import io.zeebe.logstreams.impl.service.LogStreamServiceNames;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.spi.LogStorage;
import io.zeebe.logstreams.state.StateStorage;
import io.zeebe.servicecontainer.CompositeServiceBuilder;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.util.EnsureUtil;
import io.zeebe.util.sched.channel.ActorConditions;
import io.zeebe.util.sched.future.ActorFuture;
import java.io.File;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import org.agrona.concurrent.status.AtomicLongPosition;

public class LogStreamBuilder {
    protected final int partitionId;
    protected ServiceContainer serviceContainer;
    protected String logName;
    protected String logRootPath;
    protected String logDirectory;
    protected int initialLogSegmentId = 0;
    protected boolean deleteOnClose;
    protected int maxAppendBlockSize = 0x100000;
    protected int writeBufferSize = 0x800000;
    protected int logSegmentSize = 0x8000000;
    protected int indexBlockSize = 0x400000;
    protected float deviation = 0.1f;
    protected int readBlockSize = 1024;
    protected int maxSnapshots = 1;
    protected Duration snapshotPeriod = Duration.ofMinutes(1L);
    protected final AtomicLongPosition commitPosition = new AtomicLongPosition();
    protected final ActorConditions onCommitPositionUpdatedConditions = new ActorConditions();
    protected Function<FsLogStorage, FsLogStorage> logStorageStubber = Function.identity();
    private StateStorage stateStorage;

    public LogStreamBuilder(int partitionId) {
        this.partitionId = partitionId;
    }

    public LogStreamBuilder serviceContainer(ServiceContainer serviceContainer) {
        this.serviceContainer = serviceContainer;
        return this;
    }

    public LogStreamBuilder logName(String logName) {
        this.logName = logName;
        return this;
    }

    public LogStreamBuilder logRootPath(String logRootPath) {
        this.logRootPath = logRootPath;
        return this;
    }

    public LogStreamBuilder logDirectory(String logDir) {
        this.logDirectory = logDir;
        return this;
    }

    public LogStreamBuilder writeBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return this;
    }

    public LogStreamBuilder maxAppendBlockSize(int maxAppendBlockSize) {
        this.maxAppendBlockSize = maxAppendBlockSize;
        return this;
    }

    public LogStreamBuilder initialLogSegmentId(int logFragmentId) {
        this.initialLogSegmentId = logFragmentId;
        return this;
    }

    public LogStreamBuilder logSegmentSize(int logSegmentSize) {
        this.logSegmentSize = logSegmentSize;
        return this;
    }

    public LogStreamBuilder deleteOnClose(boolean deleteOnClose) {
        this.deleteOnClose = deleteOnClose;
        return this;
    }

    public LogStreamBuilder indexBlockSize(int indexBlockSize) {
        this.indexBlockSize = indexBlockSize;
        return this;
    }

    public LogStreamBuilder deviation(float deviation) {
        this.deviation = deviation;
        return this;
    }

    public LogStreamBuilder indexStateStorage(StateStorage stateStorage) {
        this.stateStorage = stateStorage;
        return this;
    }

    public LogStreamBuilder snapshotPeriod(Duration snapshotPeriod) {
        this.snapshotPeriod = snapshotPeriod;
        return this;
    }

    public LogStreamBuilder maxSnapshots(int maxSnapshots) {
        this.maxSnapshots = maxSnapshots;
        return this;
    }

    public LogStreamBuilder readBlockSize(int readBlockSize) {
        this.readBlockSize = readBlockSize;
        return this;
    }

    public LogStreamBuilder logStorageStubber(Function<FsLogStorage, FsLogStorage> logStorageStubber) {
        this.logStorageStubber = logStorageStubber;
        return this;
    }

    public String getLogName() {
        return this.logName;
    }

    public String getLogDirectory() {
        if (this.logDirectory == null) {
            this.logDirectory = this.logRootPath + File.separatorChar + this.logName + File.separatorChar;
        }
        return this.logDirectory;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public int getMaxAppendBlockSize() {
        return this.maxAppendBlockSize;
    }

    public int getIndexBlockSize() {
        return this.indexBlockSize;
    }

    public int getReadBlockSize() {
        return this.readBlockSize;
    }

    public Duration getSnapshotPeriod() {
        return this.snapshotPeriod;
    }

    public int getMaxSnapshots() {
        return this.maxSnapshots;
    }

    public float getDeviation() {
        return this.deviation;
    }

    public ServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    public AtomicLongPosition getCommitPosition() {
        return this.commitPosition;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public ActorConditions getOnCommitPositionUpdatedConditions() {
        return this.onCommitPositionUpdatedConditions;
    }

    public ServiceName<LogStream> buildWith(CompositeServiceBuilder composite) {
        this.validate();
        return this.addServices(composite);
    }

    public ActorFuture<LogStream> build() {
        Objects.requireNonNull(this.serviceContainer, "serviceContainer");
        this.validate();
        CompositeServiceBuilder installOperation = this.serviceContainer.createComposite(LogStreamServiceNames.logStreamRootServiceName(this.logName));
        ServiceName<LogStream> logStreamServiceName = this.addServices(installOperation);
        return installOperation.installAndReturn(logStreamServiceName);
    }

    private ServiceName<LogStream> addServices(CompositeServiceBuilder installOperation) {
        ServiceName<LogStorage> logStorageServiceName = LogStreamServiceNames.logStorageServiceName(this.logName);
        ServiceName<LogBlockIndex> logBlockIndexServiceName = LogStreamServiceNames.logBlockIndexServiceName(this.logName);
        ServiceName<LogBlockIndexWriter> logBlockIndexWriterServiceName = LogStreamServiceNames.logBlockIndexWriterService(this.logName);
        ServiceName<LogStream> logStreamServiceName = LogStreamServiceNames.logStreamServiceName(this.logName);
        FsLogStorageConfiguration storageConfig = new FsLogStorageConfiguration(this.logSegmentSize, this.getLogDirectory(), this.initialLogSegmentId, this.deleteOnClose);
        FsLogStorageService logStorageService = new FsLogStorageService(storageConfig, this.partitionId, this.logStorageStubber);
        installOperation.createService(logStorageServiceName, (Service)logStorageService).install();
        LogBlockIndexService logBlockIndexService = new LogBlockIndexService(this.stateStorage, this.maxSnapshots);
        installOperation.createService(logBlockIndexServiceName, (Service)logBlockIndexService).install();
        LogBlockIndexWriterService logBlockIndexWriterService = new LogBlockIndexWriterService(this);
        installOperation.createService(logBlockIndexWriterServiceName, (Service)logBlockIndexWriterService).dependency(logStorageServiceName, logBlockIndexWriterService.getLogStorageInjector()).dependency(logBlockIndexServiceName, logBlockIndexWriterService.getLogBlockIndexInjector()).install();
        LogStreamService logStreamService = new LogStreamService(this);
        installOperation.createService(logStreamServiceName, (Service)logStreamService).dependency(logStorageServiceName, logStreamService.getLogStorageInjector()).dependency(logBlockIndexServiceName, logStreamService.getLogBlockIndexInjector()).dependency(logBlockIndexWriterServiceName, logStreamService.getLogBockIndexWriterInjector()).install();
        return logStreamServiceName;
    }

    private void validate() {
        Objects.requireNonNull(this.logName, "logName");
        EnsureUtil.ensureGreaterThanOrEqual((String)"partitionId", (long)this.partitionId, (long)0L);
        EnsureUtil.ensureFalse((String)"deviation", (this.deviation <= 0.0f || this.deviation > 1.0f ? 1 : 0) != 0);
        Objects.requireNonNull(this.stateStorage, "indexStateStorage");
    }
}

