/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl;

import io.zeebe.dispatcher.impl.log.DataFrameDescriptor;
import io.zeebe.logstreams.impl.LogEntryDescriptor;
import io.zeebe.logstreams.impl.ReadableFragment;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.protocol.Protocol;
import io.zeebe.protocol.record.VarDataEncodingEncoder;
import io.zeebe.util.buffer.BufferReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class LoggedEventImpl
implements ReadableFragment,
LoggedEvent {
    protected int fragmentOffset = -1;
    protected int messageOffset = -1;
    protected DirectBuffer buffer;

    public void wrap(DirectBuffer buffer, int offset) {
        this.fragmentOffset = offset;
        this.messageOffset = DataFrameDescriptor.messageOffset((int)this.fragmentOffset);
        this.buffer = buffer;
    }

    @Override
    public int getType() {
        return this.buffer.getShort(DataFrameDescriptor.typeOffset((int)this.fragmentOffset), Protocol.ENDIANNESS);
    }

    @Override
    public int getVersion() {
        return this.buffer.getShort(DataFrameDescriptor.versionOffset((int)this.fragmentOffset), Protocol.ENDIANNESS);
    }

    @Override
    public int getMessageLength() {
        return DataFrameDescriptor.messageLength((int)this.buffer.getInt(DataFrameDescriptor.lengthOffset((int)this.fragmentOffset), Protocol.ENDIANNESS));
    }

    @Override
    public int getMessageOffset() {
        return this.messageOffset;
    }

    @Override
    public int getStreamId() {
        return this.buffer.getInt(DataFrameDescriptor.streamIdOffset((int)this.fragmentOffset), Protocol.ENDIANNESS);
    }

    @Override
    public DirectBuffer getBuffer() {
        return this.buffer;
    }

    public int getFragmentLength() {
        return LogEntryDescriptor.getFragmentLength(this.buffer, this.fragmentOffset);
    }

    public int getFragmentOffset() {
        return this.fragmentOffset;
    }

    @Override
    public long getPosition() {
        return LogEntryDescriptor.getPosition(this.buffer, this.fragmentOffset);
    }

    @Override
    public long getKey() {
        return LogEntryDescriptor.getKey(this.buffer, this.messageOffset);
    }

    @Override
    public long getTimestamp() {
        return LogEntryDescriptor.getTimestamp(this.buffer, this.messageOffset);
    }

    @Override
    public DirectBuffer getMetadata() {
        return this.buffer;
    }

    @Override
    public short getMetadataLength() {
        return LogEntryDescriptor.getMetadataLength(this.buffer, this.messageOffset);
    }

    @Override
    public int getMaxValueLength() {
        return VarDataEncodingEncoder.lengthMaxValue() - LogEntryDescriptor.headerLength(this.getMetadataLength());
    }

    @Override
    public int getMetadataOffset() {
        return LogEntryDescriptor.metadataOffset(this.messageOffset);
    }

    @Override
    public void readMetadata(BufferReader reader) {
        reader.wrap(this.buffer, this.getMetadataOffset(), (int)this.getMetadataLength());
    }

    @Override
    public int getValueOffset() {
        short metadataLength = this.getMetadataLength();
        return LogEntryDescriptor.valueOffset(this.messageOffset, metadataLength);
    }

    @Override
    public int getValueLength() {
        short metadataLength = this.getMetadataLength();
        return this.getMessageLength() - LogEntryDescriptor.headerLength(metadataLength);
    }

    @Override
    public DirectBuffer getValueBuffer() {
        return this.buffer;
    }

    @Override
    public void readValue(BufferReader reader) {
        reader.wrap(this.buffer, this.getValueOffset(), this.getValueLength());
    }

    @Override
    public long getSourceEventPosition() {
        return LogEntryDescriptor.getSourceEventPosition(this.buffer, this.messageOffset);
    }

    @Override
    public int getProducerId() {
        return LogEntryDescriptor.getProducerId(this.buffer, this.messageOffset);
    }

    public String toString() {
        return "LoggedEvent [type=" + this.getType() + ", version=" + this.getVersion() + ", streamId=" + this.getStreamId() + ", position=" + this.getPosition() + ", key=" + this.getKey() + ", timestamp=" + this.getTimestamp() + ", sourceEventPosition=" + this.getSourceEventPosition() + ", producerId=" + this.getProducerId() + "]";
    }

    public int getLength() {
        return this.getFragmentLength();
    }

    public void write(MutableDirectBuffer destination, int offset) {
        destination.putBytes(offset, this.buffer, this.fragmentOffset, this.getLength());
    }
}

