/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.log.fs;

import io.zeebe.logstreams.impl.log.fs.FsLogSegment;

public class FsLogSegments {
    protected int initialSegmentId = -1;
    protected FsLogSegment[] segments = new FsLogSegment[0];
    protected volatile int segmentCount = 0;

    public void init(int initialSegmentId, FsLogSegment[] initialSegments) {
        this.segments = initialSegments;
        this.initialSegmentId = initialSegmentId;
        this.segmentCount = initialSegments.length;
    }

    public void addSegment(FsLogSegment segment) {
        FsLogSegment[] newSegments = new FsLogSegment[this.segments.length + 1];
        System.arraycopy(this.segments, 0, newSegments, 0, this.segments.length);
        newSegments[this.segments.length] = segment;
        this.segments = newSegments;
        this.segmentCount = newSegments.length;
    }

    public void removeSegmentsUntil(int segmentId) {
        int segmentIdx = segmentId - this.initialSegmentId;
        int newLength = this.segments.length - segmentIdx;
        FsLogSegment[] newSegments = new FsLogSegment[newLength];
        System.arraycopy(this.segments, segmentIdx, newSegments, 0, newLength);
        this.segments = newSegments;
        this.initialSegmentId += segmentIdx;
        this.segmentCount = newSegments.length;
    }

    public FsLogSegment getSegment(int segmentId) {
        int segmentCount = this.segmentCount;
        FsLogSegment[] segments = this.segments;
        int segmentIdx = segmentId - this.initialSegmentId;
        if (0 <= segmentIdx && segmentIdx < segmentCount) {
            return segments[segmentIdx];
        }
        return null;
    }

    public FsLogSegment getFirst() {
        if (this.segmentCount > 0) {
            return this.segments[0];
        }
        return null;
    }

    public void closeAll() {
        FsLogSegment[] segments;
        for (FsLogSegment readableLogSegment : segments = this.segments) {
            readableLogSegment.closeSegment();
        }
        this.segments = new FsLogSegment[0];
        this.segmentCount = 0;
    }

    public int getLastSegmentId() {
        return this.initialSegmentId + (this.segmentCount - 1);
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }
}

