/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.log.index;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbLong;
import io.zeebe.logstreams.impl.Loggers;
import io.zeebe.logstreams.impl.log.index.LogBlockColumnFamilies;
import io.zeebe.logstreams.impl.log.index.LogBlockIndexContext;
import io.zeebe.logstreams.state.StateSnapshotController;
import java.util.concurrent.atomic.AtomicLong;

public class LogBlockIndex {
    private static final String ERROR_MSG_ENSURING_MAX_SNAPSHOT_COUNT = "Unexpected exception occurred on ensuring maximum snapshot count.";
    public static final int VALUE_NOT_FOUND = -1;
    private long lastVirtualPosition = -1L;
    private final StateSnapshotController stateSnapshotController;
    private ZeebeDb<LogBlockColumnFamilies> zeebeDb;
    private ColumnFamily<DbLong, DbLong> indexColumnFamily;

    public LogBlockIndex(StateSnapshotController snapshotController) {
        this.stateSnapshotController = snapshotController;
        this.tryToRestoreAndOpen();
    }

    private void tryToRestoreAndOpen() {
        try {
            this.lastVirtualPosition = this.stateSnapshotController.recover();
        }
        catch (Exception e) {
            Loggers.ROCKSDB_LOGGER.debug("Log block index failed to recover from snapshot", (Throwable)e);
        }
        this.zeebeDb = this.stateSnapshotController.openDb();
        this.indexColumnFamily = this.zeebeDb.createColumnFamily((Enum)LogBlockColumnFamilies.BLOCK_POSITION_ADDRESS, this.zeebeDb.createContext(), (DbKey)new DbLong(), (DbValue)new DbLong());
    }

    public void closeDb() throws Exception {
        if (this.zeebeDb != null) {
            this.stateSnapshotController.close();
            this.zeebeDb = null;
            this.indexColumnFamily = null;
        }
    }

    public long lookupBlockAddress(LogBlockIndexContext indexContext, long entryPosition) {
        long blockPosition = this.lookupBlockPosition(indexContext, entryPosition);
        if (blockPosition == -1L) {
            return -1L;
        }
        DbLong dbBlockPosition = indexContext.writeKeyInstance(blockPosition);
        DbLong address = (DbLong)this.indexColumnFamily.get(indexContext.getDbContext(), (DbKey)dbBlockPosition, (DbValue)indexContext.getValueInstance());
        return address != null ? address.getValue() : -1L;
    }

    public long lookupBlockPosition(LogBlockIndexContext indexContext, long entryPosition) {
        AtomicLong blockPosition = new AtomicLong(-1L);
        this.indexColumnFamily.whileTrue(indexContext.getDbContext(), (key, val) -> {
            long currentBlockPosition = key.getValue();
            if (currentBlockPosition <= entryPosition) {
                blockPosition.set(currentBlockPosition);
                return true;
            }
            return false;
        }, (DbKey)indexContext.getKeyInstance(), (DbValue)indexContext.getValueInstance());
        return blockPosition.get();
    }

    public void addBlock(LogBlockIndexContext indexContext, long blockPosition, long blockAddress) {
        if (this.lastVirtualPosition >= blockPosition) {
            String errorMessage = String.format("Illegal value for position.Value=%d, last value in index=%d. Must provide positions in ascending order.", blockPosition, this.lastVirtualPosition);
            throw new IllegalArgumentException(errorMessage);
        }
        DbLong dbBlockPosition = indexContext.writeKeyInstance(blockPosition);
        DbLong dbBlockAddress = indexContext.writeValueInstance(blockAddress);
        this.indexColumnFamily.put(indexContext.getDbContext(), (DbKey)dbBlockPosition, (DbValue)dbBlockAddress);
        this.lastVirtualPosition = blockPosition;
    }

    public void deleteUpToPosition(LogBlockIndexContext indexContext, long deletePosition) {
        AtomicLong lastBlockPosition = new AtomicLong(-1L);
        this.indexColumnFamily.whileTrue(indexContext.getDbContext(), (key, val) -> {
            long storedBlockPosition = key.getValue();
            if (storedBlockPosition <= deletePosition) {
                if (lastBlockPosition.get() != -1L) {
                    this.deleteEntry(indexContext, lastBlockPosition.get());
                }
                lastBlockPosition.set(storedBlockPosition);
                return true;
            }
            return false;
        }, (DbKey)indexContext.getKeyInstance(), (DbValue)indexContext.getValueInstance());
    }

    private void deleteEntry(LogBlockIndexContext indexContext, long blockPosition) {
        DbLong dbBlockPosition = indexContext.writeKeyInstance(blockPosition);
        this.indexColumnFamily.delete(indexContext.getDbContext(), (DbKey)dbBlockPosition);
    }

    public boolean isEmpty(LogBlockIndexContext indexContext) {
        return this.indexColumnFamily.isEmpty(indexContext.getDbContext());
    }

    public void writeSnapshot(long snapshotEventPosition) {
        this.stateSnapshotController.takeSnapshot(snapshotEventPosition);
        try {
            this.stateSnapshotController.ensureMaxSnapshotCount();
        }
        catch (Exception e) {
            Loggers.SNAPSHOT_LOGGER.error(ERROR_MSG_ENSURING_MAX_SNAPSHOT_COUNT, (Throwable)e);
        }
    }

    public long getLastPosition() {
        return this.lastVirtualPosition;
    }

    public LogBlockIndexContext createLogBlockIndexContext() {
        return new LogBlockIndexContext(this.zeebeDb.createContext());
    }
}

