/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.service;

import io.zeebe.db.ZeebeDbFactory;
import io.zeebe.db.impl.rocksdb.ZeebeRocksDbFactory;
import io.zeebe.logstreams.impl.LogBlockIndexWriter;
import io.zeebe.logstreams.impl.log.index.LogBlockColumnFamilies;
import io.zeebe.logstreams.impl.log.index.LogBlockIndex;
import io.zeebe.logstreams.state.StateSnapshotController;
import io.zeebe.logstreams.state.StateStorage;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;

public class LogBlockIndexService
implements Service<LogBlockIndex> {
    private final int maxSnapshotCount;
    private LogBlockIndex logBlockIndex;
    private final StateStorage stateStorage;

    public LogBlockIndexService(StateStorage stateStorage, int maxSnapshotCount) {
        this.stateStorage = stateStorage;
        this.maxSnapshotCount = maxSnapshotCount;
    }

    public void start(ServiceStartContext startContext) {
        ZeebeDbFactory dbFactory = ZeebeRocksDbFactory.newFactory(LogBlockColumnFamilies.class);
        StateSnapshotController snapshotController = new StateSnapshotController(dbFactory, this.stateStorage, this.maxSnapshotCount);
        this.logBlockIndex = new LogBlockIndex(snapshotController);
    }

    public void stop(ServiceStopContext stopContext) {
        if (this.logBlockIndex != null) {
            try {
                this.logBlockIndex.closeDb();
            }
            catch (Exception e) {
                LogBlockIndexWriter.LOG.error("Couldn't close block index db", (Throwable)e);
            }
            this.logBlockIndex = null;
        }
    }

    public LogBlockIndex get() {
        return this.logBlockIndex;
    }
}

