/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.service;

import io.zeebe.logstreams.impl.LogBlockIndexWriter;
import io.zeebe.logstreams.impl.LogStreamBuilder;
import io.zeebe.logstreams.impl.log.index.LogBlockIndex;
import io.zeebe.logstreams.spi.LogStorage;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.SchedulingHints;

public class LogBlockIndexWriterService
implements Service<LogBlockIndexWriter> {
    private final Injector<LogBlockIndex> logBlockIndexInjector = new Injector();
    private final Injector<LogStorage> logStorageInjector = new Injector();
    private LogBlockIndexWriter logBlockIndexWriter;
    private LogStreamBuilder logStreamBuilder;

    public LogBlockIndexWriterService(LogStreamBuilder logStreamBuilder) {
        this.logStreamBuilder = logStreamBuilder;
    }

    public void start(ServiceStartContext startContext) {
        LogBlockIndex logBlockIndex = (LogBlockIndex)this.logBlockIndexInjector.getValue();
        LogStorage logStorage = (LogStorage)this.logStorageInjector.getValue();
        ActorScheduler scheduler = startContext.getScheduler();
        this.logBlockIndexWriter = new LogBlockIndexWriter(startContext.getName(), this.logStreamBuilder, logStorage, logBlockIndex, scheduler.getMetricsManager());
        startContext.async(scheduler.submitActor((Actor)this.logBlockIndexWriter, true, SchedulingHints.ioBound()));
    }

    public void stop(ServiceStopContext stopContext) {
        stopContext.async(this.logBlockIndexWriter.closeAsync());
    }

    public LogBlockIndexWriter get() {
        return this.logBlockIndexWriter;
    }

    public Injector<LogBlockIndex> getLogBlockIndexInjector() {
        return this.logBlockIndexInjector;
    }

    public Injector<LogStorage> getLogStorageInjector() {
        return this.logStorageInjector;
    }
}

