/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.service;

import io.zeebe.dispatcher.Subscription;
import io.zeebe.distributedlog.impl.DistributedLogstreamPartition;
import io.zeebe.logstreams.impl.LogStorageAppender;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.SchedulingHints;

public class LogStorageAppenderService
implements Service<LogStorageAppender> {
    private final Injector<Subscription> appenderSubscriptionInjector = new Injector();
    private final Injector<DistributedLogstreamPartition> distributedLogstreamInjector = new Injector();
    private final int maxAppendBlockSize;
    private LogStorageAppender service;

    public LogStorageAppenderService(int maxAppendBlockSize) {
        this.maxAppendBlockSize = maxAppendBlockSize;
    }

    public void start(ServiceStartContext startContext) {
        Subscription subscription = (Subscription)this.appenderSubscriptionInjector.getValue();
        this.service = new LogStorageAppender(startContext.getName(), (DistributedLogstreamPartition)this.distributedLogstreamInjector.getValue(), subscription, this.maxAppendBlockSize);
        startContext.async(startContext.getScheduler().submitActor((Actor)this.service, true, SchedulingHints.ioBound()));
    }

    public void stop(ServiceStopContext stopContext) {
        stopContext.async(this.service.close());
    }

    public LogStorageAppender get() {
        return this.service;
    }

    public Injector<Subscription> getAppenderSubscriptionInjector() {
        return this.appenderSubscriptionInjector;
    }

    public Injector<DistributedLogstreamPartition> getDistributedLogstreamInjector() {
        return this.distributedLogstreamInjector;
    }
}

