/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.service;

import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.Subscription;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.sched.future.ActorFuture;

public class LogWriteBufferSubscriptionService
implements Service<Subscription> {
    private final Injector<Dispatcher> logWritebufferInjector = new Injector();
    private final String subscriptionName;
    private ActorFuture<Subscription> subscriptionFuture;

    public LogWriteBufferSubscriptionService(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public void start(ServiceStartContext startContext) {
        Dispatcher logBuffer = (Dispatcher)this.logWritebufferInjector.getValue();
        this.subscriptionFuture = logBuffer.openSubscriptionAsync(this.subscriptionName);
        startContext.async(this.subscriptionFuture);
    }

    public void stop(ServiceStopContext stopContext) {
        Dispatcher logBuffer = (Dispatcher)this.logWritebufferInjector.getValue();
        stopContext.async(logBuffer.closeSubscriptionAsync((Subscription)this.subscriptionFuture.join()));
    }

    public Subscription get() {
        return (Subscription)this.subscriptionFuture.join();
    }

    public Injector<Dispatcher> getWritebufferInjector() {
        return this.logWritebufferInjector;
    }
}

