/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.log;

import io.zeebe.logstreams.impl.CompleteEventsInBlockProcessor;
import io.zeebe.logstreams.impl.LogEntryDescriptor;
import io.zeebe.logstreams.impl.LoggedEventImpl;
import io.zeebe.logstreams.impl.log.index.LogBlockIndex;
import io.zeebe.logstreams.impl.log.index.LogBlockIndexContext;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.logstreams.spi.LogStorage;
import io.zeebe.logstreams.spi.ReadResultProcessor;
import io.zeebe.util.allocation.AllocatedBuffer;
import io.zeebe.util.allocation.BufferAllocator;
import io.zeebe.util.allocation.DirectBufferAllocator;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class BufferedLogStreamReader
implements LogStreamReader {
    public static final int DEFAULT_INITIAL_BUFFER_CAPACITY = 32768;
    public static final int MAX_BUFFER_CAPACITY = 0x8000000;
    private static final int UNINITIALIZED = -1;
    private static final long FIRST_POSITION = Long.MIN_VALUE;
    private static final long LAST_POSITION = Long.MAX_VALUE;
    private final ReadResultProcessor completeEventsInBlockProcessor = new CompleteEventsInBlockProcessor();
    private LogStorage logStorage;
    private LogBlockIndex logBlockIndex;
    private LogBlockIndexContext indexContext;
    private IteratorState state;
    private long nextLogStorageReadAddress;
    private final LoggedEventImpl nextEvent = new LoggedEventImpl();
    private final LoggedEventImpl returnedEvent = new LoggedEventImpl();
    private final BufferAllocator bufferAllocator = new DirectBufferAllocator();
    private AllocatedBuffer allocatedBuffer;
    private ByteBuffer byteBuffer;
    private int bufferOffset;
    private final DirectBuffer directBuffer = new UnsafeBuffer(0L, 0);

    public BufferedLogStreamReader(LogStream logStream) {
        this();
        this.wrap(logStream);
    }

    public BufferedLogStreamReader() {
        this.state = IteratorState.WRAP_NOT_CALLED;
    }

    @Override
    public void wrap(LogStream log) {
        this.wrap(log, Long.MIN_VALUE);
    }

    @Override
    public void wrap(LogStream log, long position) {
        this.wrap(log.getLogStorage(), log.getLogBlockIndex(), position);
    }

    public void wrap(LogStorage logStorage, LogBlockIndex logBlockIndex) {
        this.wrap(logStorage, logBlockIndex, Long.MIN_VALUE);
    }

    public void wrap(LogStorage logStorage, LogBlockIndex logBlockIndex, long position) {
        this.logStorage = logStorage;
        this.logBlockIndex = logBlockIndex;
        this.indexContext = logBlockIndex.createLogBlockIndexContext();
        if (this.isClosed()) {
            this.allocateBuffer(32768);
        }
        this.seek(position);
    }

    @Override
    public boolean seekToNextEvent(long position) {
        if (position <= -1L) {
            this.seekToFirstEvent();
            return true;
        }
        boolean found = this.seek(position);
        if (found && this.hasNext()) {
            this.next();
            return true;
        }
        return false;
    }

    @Override
    public boolean seek(long position) {
        if (this.state == IteratorState.WRAP_NOT_CALLED) {
            throw new IllegalStateException("Iterator not initialized");
        }
        this.invalidateBufferAndOffsets();
        long blockAddress = this.lookUpBlockAddressForPosition(position);
        if (blockAddress < 0L) {
            this.state = IteratorState.EMPTY_LOG_STREAM;
            return false;
        }
        this.readBlockIntoBuffer(blockAddress);
        this.readNextEvent();
        return this.searchPositionInBuffer(position);
    }

    @Override
    public void seekToFirstEvent() {
        this.seek(Long.MIN_VALUE);
    }

    @Override
    public void seekToLastEvent() {
        this.seek(this.getLastPosition());
        if (this.isNextEventInitialized()) {
            this.checkIfNextEventIsCommitted();
        }
    }

    @Override
    public long getPosition() {
        if (this.isReturnedEventInitialized()) {
            return this.returnedEvent.getPosition();
        }
        switch (this.state) {
            case EVENT_AVAILABLE: {
                return this.nextEvent.getPosition();
            }
        }
        return -1L;
    }

    @Override
    public boolean isClosed() {
        return this.allocatedBuffer == null;
    }

    public void close() {
        if (this.allocatedBuffer != null) {
            this.allocatedBuffer.close();
            this.allocatedBuffer = null;
            this.byteBuffer = null;
            this.directBuffer.wrap(0L, 0);
            this.bufferOffset = 0;
            this.logStorage = null;
            this.logBlockIndex = null;
            this.state = IteratorState.WRAP_NOT_CALLED;
        }
    }

    @Override
    public boolean hasNext() {
        switch (this.state) {
            case EMPTY_LOG_STREAM: {
                this.seekToFirstEvent();
                break;
            }
            case NOT_ENOUGH_DATA: {
                this.readNextAddress();
                break;
            }
            case EVENT_NOT_COMMITTED: {
                this.checkIfNextEventIsCommitted();
                break;
            }
            case WRAP_NOT_CALLED: {
                throw new IllegalStateException("Iterator not initialized");
            }
        }
        return this.state == IteratorState.EVENT_AVAILABLE;
    }

    @Override
    public LoggedEvent next() {
        switch (this.state) {
            case EVENT_AVAILABLE: {
                this.wrapReturnedEvent(this.nextEvent.getFragmentOffset());
                this.readNextEvent();
                return this.returnedEvent;
            }
            case WRAP_NOT_CALLED: {
                throw new IllegalStateException("Iterator not initialized");
            }
        }
        throw new NoSuchElementException("Api protocol violation: No next log entry available; You need to probe with hasNext() first.");
    }

    private void allocateBuffer(int capacity) {
        if (!this.isClosed() && this.allocatedBuffer != null && this.allocatedBuffer.capacity() == 0x8000000 && capacity >= 0x8000000) {
            throw new RuntimeException("Next fragment requires more space then the maximal buffer capacity of 134217728");
        }
        AllocatedBuffer newAllocatedBuffer = this.bufferAllocator.allocate(capacity);
        ByteBuffer newByteBuffer = newAllocatedBuffer.getRawBuffer();
        if (!this.isClosed()) {
            int offsetToCopy = this.minimalOffsetToPreserve();
            this.byteBuffer.position(offsetToCopy);
            this.byteBuffer.limit(this.bufferOffset);
            newByteBuffer.put(this.byteBuffer);
            this.bufferOffset -= offsetToCopy;
            this.wrapReturnedEvent(this.returnedEvent.getFragmentOffset() - offsetToCopy);
            this.wrapNextEvent(this.nextEvent.getFragmentOffset() - offsetToCopy);
        } else {
            this.invalidateBufferAndOffsets();
        }
        this.byteBuffer = newByteBuffer;
        this.directBuffer.wrap(this.byteBuffer);
        if (this.allocatedBuffer != null) {
            this.allocatedBuffer.close();
        }
        this.allocatedBuffer = newAllocatedBuffer;
    }

    private void compactBuffer() {
        if (this.isReturnedEventInitialized() || this.isNextEventInitialized()) {
            int offsetToCopy = this.minimalOffsetToPreserve();
            this.byteBuffer.position(offsetToCopy);
            this.byteBuffer.compact();
            this.bufferOffset -= offsetToCopy;
            if (this.isNextEventInitialized()) {
                this.wrapNextEvent(this.nextEvent.getFragmentOffset() - offsetToCopy);
            }
            if (this.isReturnedEventInitialized()) {
                this.wrapReturnedEvent(this.returnedEvent.getFragmentOffset() - offsetToCopy);
            }
        } else {
            this.invalidateBufferAndOffsets();
            this.byteBuffer.clear();
        }
    }

    private boolean readBlockIntoBuffer(long blockAddress) {
        long result;
        if (this.byteBuffer.remaining() < LogEntryDescriptor.HEADER_BLOCK_LENGTH) {
            this.compactBuffer();
        }
        if ((result = this.logStorage.read(this.byteBuffer, blockAddress, this.completeEventsInBlockProcessor)) == -3L) {
            long nextCapacity = 2L * (long)this.byteBuffer.capacity();
            nextCapacity = Math.min(nextCapacity, 0x8000000L);
            this.allocateBuffer((int)nextCapacity);
            return this.readBlockIntoBuffer(blockAddress);
        }
        if (result == -1L) {
            throw new IllegalStateException("Invalid address to read from " + blockAddress);
        }
        if (result == -2L) {
            this.state = IteratorState.NOT_ENOUGH_DATA;
            return false;
        }
        this.nextLogStorageReadAddress = result;
        return true;
    }

    private boolean searchPositionInBuffer(long position) {
        while (this.isNextUncommittedEventAvailable() && this.nextEvent.getPosition() < position) {
            this.readNextEvent();
        }
        if (this.nextEvent.getPosition() < position) {
            return this.readNextAddress() && this.searchPositionInBuffer(position);
        }
        return this.nextEvent.getPosition() == position;
    }

    private boolean isNextUncommittedEventAvailable() {
        return this.state == IteratorState.EVENT_AVAILABLE || this.state == IteratorState.EVENT_NOT_COMMITTED;
    }

    private long lookUpBlockAddressForPosition(long position) {
        long address = this.logBlockIndex.lookupBlockAddress(this.indexContext, position);
        if (address < 0L) {
            address = this.logStorage.getFirstBlockAddress();
        }
        return address;
    }

    private boolean readNextAddress() {
        boolean blockFound = this.readBlockIntoBuffer(this.nextLogStorageReadAddress);
        if (blockFound) {
            this.readNextEvent();
        }
        return blockFound;
    }

    private void readNextEvent() {
        this.state = IteratorState.NOT_ENOUGH_DATA;
        int remaining = this.byteBuffer.position() - this.bufferOffset;
        if (remaining > 0) {
            this.wrapNextEvent(this.bufferOffset);
            this.bufferOffset += this.nextEvent.getFragmentLength();
            this.checkIfNextEventIsCommitted();
        } else {
            this.readNextAddress();
        }
    }

    private boolean isReturnedEventInitialized() {
        return this.returnedEvent.getFragmentOffset() >= 0;
    }

    private boolean isNextEventInitialized() {
        return this.nextEvent.getFragmentOffset() >= 0;
    }

    private int minimalOffsetToPreserve() {
        if (this.isReturnedEventInitialized()) {
            return this.returnedEvent.getFragmentOffset();
        }
        if (this.isNextEventInitialized()) {
            return this.nextEvent.getFragmentOffset();
        }
        return this.bufferOffset;
    }

    private void invalidateBufferAndOffsets() {
        this.state = IteratorState.NOT_ENOUGH_DATA;
        this.wrapNextEvent(-1);
        this.wrapReturnedEvent(-1);
        this.bufferOffset = 0;
        if (!this.isClosed()) {
            this.byteBuffer.clear();
        }
    }

    private void wrapNextEvent(int offset) {
        this.nextEvent.wrap(this.directBuffer, offset);
    }

    private void wrapReturnedEvent(int offset) {
        this.returnedEvent.wrap(this.directBuffer, offset);
    }

    private void checkIfNextEventIsCommitted() {
        this.state = IteratorState.EVENT_AVAILABLE;
    }

    private long getLastPosition() {
        return Long.MAX_VALUE;
    }

    static enum IteratorState {
        WRAP_NOT_CALLED,
        EMPTY_LOG_STREAM,
        EVENT_AVAILABLE,
        NOT_ENOUGH_DATA,
        EVENT_NOT_COMMITTED;

    }
}

