/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.state;

import io.zeebe.logstreams.impl.Loggers;
import io.zeebe.logstreams.spi.ValidSnapshotListener;
import io.zeebe.logstreams.state.FileSnapshotConsumer;
import io.zeebe.logstreams.state.SnapshotChunk;
import io.zeebe.logstreams.state.SnapshotChunkUtil;
import io.zeebe.logstreams.state.SnapshotConsumer;
import io.zeebe.logstreams.state.SnapshotReplication;
import io.zeebe.logstreams.state.StateStorage;
import java.io.File;
import java.io.IOException;
import org.agrona.collections.Long2LongHashMap;
import org.slf4j.Logger;

public final class ReplicationController {
    private static final Logger LOG = Loggers.SNAPSHOT_LOGGER;
    private static final long START_VALUE = 0L;
    private static final long INVALID_SNAPSHOT = -1L;
    private static final long MISSING_SNAPSHOT = Long.MIN_VALUE;
    private static final ValidSnapshotListener NOOP_VALID_SNAPSHOT_LISTENER = () -> {};
    private final SnapshotReplication replication;
    private final Long2LongHashMap receivedSnapshots = new Long2LongHashMap(Long.MIN_VALUE);
    private final StateStorage storage;
    private final SnapshotConsumer snapshotConsumer;
    private final ValidSnapshotListener validSnapshotListener;

    public ReplicationController(SnapshotReplication replication, StateStorage storage) {
        this(replication, storage, NOOP_VALID_SNAPSHOT_LISTENER);
    }

    public ReplicationController(SnapshotReplication replication, StateStorage storage, ValidSnapshotListener validSnapshotListener) {
        this.replication = replication;
        this.storage = storage;
        this.validSnapshotListener = validSnapshotListener;
        this.snapshotConsumer = new FileSnapshotConsumer(storage, LOG);
    }

    public void replicate(long snapshotPosition, int totalCount, File snapshotChunkFile) {
        try {
            SnapshotChunk chunkToReplicate = SnapshotChunkUtil.createSnapshotChunkFromFile(snapshotChunkFile, snapshotPosition, totalCount);
            this.replication.replicate(chunkToReplicate);
        }
        catch (IOException ioe) {
            LOG.error("Unexpected error on reading snapshot chunk from file '{}'.", (Object)snapshotChunkFile, (Object)ioe);
        }
    }

    public void consumeReplicatedSnapshots() {
        this.replication.consume(this::consumeSnapshotChunk);
    }

    private void consumeSnapshotChunk(SnapshotChunk snapshotChunk) {
        long snapshotPosition = snapshotChunk.getSnapshotPosition();
        String snapshotName = Long.toString(snapshotPosition);
        String chunkName = snapshotChunk.getChunkName();
        long snapshotCounter = this.receivedSnapshots.computeIfAbsent(snapshotPosition, k -> 0L);
        if (snapshotCounter == -1L) {
            LOG.debug("Ignore snapshot chunk {}, because snapshot {} is marked as invalid.", (Object)chunkName, (Object)snapshotName);
            return;
        }
        if (this.snapshotConsumer.consumeSnapshotChunk(snapshotChunk)) {
            this.validateWhenReceivedAllChunks(snapshotChunk);
        } else {
            this.markSnapshotAsInvalid(snapshotChunk);
        }
    }

    private void markSnapshotAsInvalid(SnapshotChunk chunk) {
        long snapshotPosition = chunk.getSnapshotPosition();
        this.receivedSnapshots.put(snapshotPosition, -1L);
    }

    private void validateWhenReceivedAllChunks(SnapshotChunk snapshotChunk) {
        int totalChunkCount = snapshotChunk.getTotalCount();
        long currentChunks = this.incrementAndGetChunkCount(snapshotChunk);
        if (currentChunks == (long)totalChunkCount) {
            File validSnapshotDirectory = this.storage.getSnapshotDirectoryFor(snapshotChunk.getSnapshotPosition());
            LOG.debug("Received all snapshot chunks ({}/{}), snapshot is valid. Move to {}", new Object[]{currentChunks, totalChunkCount, validSnapshotDirectory.toPath()});
            boolean valid = this.tryToMarkSnapshotAsValid(snapshotChunk);
            if (valid) {
                this.validSnapshotListener.onNewValidSnapshot();
            }
        } else {
            LOG.debug("Waiting for more snapshot chunks, currently have {}/{}.", (Object)currentChunks, (Object)totalChunkCount);
        }
    }

    private long incrementAndGetChunkCount(SnapshotChunk snapshotChunk) {
        long snapshotPosition = snapshotChunk.getSnapshotPosition();
        long oldCount = this.receivedSnapshots.get(snapshotPosition);
        long newCount = oldCount + 1L;
        this.receivedSnapshots.put(snapshotPosition, newCount);
        return newCount;
    }

    private boolean tryToMarkSnapshotAsValid(SnapshotChunk snapshotChunk) {
        if (this.snapshotConsumer.completeSnapshot(snapshotChunk.getSnapshotPosition())) {
            this.receivedSnapshots.remove(snapshotChunk.getSnapshotPosition());
            return true;
        }
        this.markSnapshotAsInvalid(snapshotChunk);
        return false;
    }
}

