/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.TypeSignature;
import io.github.classgraph.utils.Parser;
import java.util.Set;

public class BaseTypeSignature
extends TypeSignature {
    private final String baseType;

    private BaseTypeSignature(String baseType) {
        this.baseType = baseType;
    }

    public String getTypeStr() {
        return this.baseType;
    }

    public Class<?> getType() {
        switch (this.baseType) {
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        throw new IllegalArgumentException("Unknown base type " + this.baseType);
    }

    @Override
    Class<?> loadClass() {
        return this.getType();
    }

    @Override
    <T> Class<T> loadClass(Class<T> superclassOrInterfaceType) {
        Class<?> type = this.getType();
        if (!superclassOrInterfaceType.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Primitive class " + this.baseType + " cannot be cast to " + superclassOrInterfaceType.getName());
        }
        Class<?> classT = type;
        return classT;
    }

    static BaseTypeSignature parse(Parser parser) {
        switch (parser.peek()) {
            case 'B': {
                parser.next();
                return new BaseTypeSignature("byte");
            }
            case 'C': {
                parser.next();
                return new BaseTypeSignature("char");
            }
            case 'D': {
                parser.next();
                return new BaseTypeSignature("double");
            }
            case 'F': {
                parser.next();
                return new BaseTypeSignature("float");
            }
            case 'I': {
                parser.next();
                return new BaseTypeSignature("int");
            }
            case 'J': {
                parser.next();
                return new BaseTypeSignature("long");
            }
            case 'S': {
                parser.next();
                return new BaseTypeSignature("short");
            }
            case 'Z': {
                parser.next();
                return new BaseTypeSignature("boolean");
            }
            case 'V': {
                parser.next();
                return new BaseTypeSignature("void");
            }
        }
        return null;
    }

    @Override
    protected String getClassName() {
        throw new IllegalArgumentException("getClassName() cannot be called here");
    }

    @Override
    protected ClassInfo getClassInfo() {
        throw new IllegalArgumentException("getClassInfo() cannot be called here");
    }

    @Override
    void getClassNamesFromTypeDescriptors(Set<String> classNameListOut) {
    }

    public int hashCode() {
        return this.baseType.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof BaseTypeSignature && ((BaseTypeSignature)obj).baseType.equals(this.baseType);
    }

    @Override
    public boolean equalsIgnoringTypeParams(TypeSignature other) {
        if (!(other instanceof BaseTypeSignature)) {
            return false;
        }
        return this.baseType.equals(((BaseTypeSignature)other).baseType);
    }

    public String toString() {
        return this.baseType;
    }
}

