/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.json;

import io.github.classgraph.json.JSONArray;
import io.github.classgraph.json.JSONObject;
import io.github.classgraph.utils.Parser;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

class JSONParser
extends Parser {
    private JSONParser(String string) throws Parser.ParseException {
        super(string);
    }

    private CharSequence parseString() throws Parser.ParseException {
        this.skipWhitespace();
        if (this.peek() != '\"') {
            return null;
        }
        this.next();
        int startIdx = this.getPosition();
        boolean hasEscape = false;
        block13: while (this.hasMore()) {
            char c = this.getc();
            if (c == '\\') {
                switch (this.getc()) {
                    case '\"': 
                    case '\'': 
                    case '/': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        hasEscape = true;
                        continue block13;
                    }
                    case 'u': {
                        hasEscape = true;
                        this.advance(4);
                        continue block13;
                    }
                }
                throw new Parser.ParseException(this, "Invalid escape sequence: \\" + c);
            }
            if (c != '\"') continue;
            break;
        }
        int endIdx = this.getPosition() - 1;
        if (!hasEscape) {
            return this.getSubsequence(startIdx, endIdx);
        }
        this.setPosition(startIdx);
        StringBuilder buf = new StringBuilder();
        block14: while (this.hasMore()) {
            char c = this.getc();
            if (c == '\\') {
                switch (this.getc()) {
                    case 'b': {
                        buf.append('\b');
                        continue block14;
                    }
                    case 'f': {
                        buf.append('\f');
                        continue block14;
                    }
                    case 'n': {
                        buf.append('\n');
                        continue block14;
                    }
                    case 'r': {
                        buf.append('\r');
                        continue block14;
                    }
                    case 't': {
                        buf.append('\t');
                        continue block14;
                    }
                    case '\"': 
                    case '\'': 
                    case '/': 
                    case '\\': {
                        buf.append(c);
                        continue block14;
                    }
                    case 'u': {
                        int charVal = 0;
                        boolean charValInvalid = false;
                        char h3 = this.getc();
                        if (h3 >= '0' && h3 <= '9') {
                            charVal |= h3 - 48 << 12;
                        } else if (h3 >= 'a' && h3 <= 'f') {
                            charVal |= h3 - 97 + 10 << 12;
                        } else if (h3 >= 'A' && h3 <= 'F') {
                            charVal |= h3 - 65 + 10 << 12;
                        } else {
                            charValInvalid = true;
                        }
                        char h2 = this.getc();
                        if (h2 >= '0' && h2 <= '9') {
                            charVal |= h2 - 48 << 8;
                        } else if (h2 >= 'a' && h2 <= 'f') {
                            charVal |= h2 - 97 + 10 << 8;
                        } else if (h2 >= 'A' && h2 <= 'F') {
                            charVal |= h2 - 65 + 10 << 8;
                        } else {
                            charValInvalid = true;
                        }
                        char h1 = this.getc();
                        if (h1 >= '0' && h1 <= '9') {
                            charVal |= h1 - 48 << 4;
                        } else if (h1 >= 'a' && h1 <= 'f') {
                            charVal |= h1 - 97 + 10 << 4;
                        } else if (h1 >= 'A' && h1 <= 'F') {
                            charVal |= h1 - 65 + 10 << 4;
                        } else {
                            charValInvalid = true;
                        }
                        char h0 = this.getc();
                        if (h0 >= '0' && h0 <= '9') {
                            charVal |= h0 - 48;
                        } else if (h0 >= 'a' && h0 <= 'f') {
                            charVal |= h0 - 97 + 10;
                        } else if (h0 >= 'A' && h0 <= 'F') {
                            charVal |= h0 - 65 + 10;
                        } else {
                            charValInvalid = true;
                        }
                        if (charValInvalid) {
                            throw new Parser.ParseException(this, "Invalid Unicode escape sequence: \\" + c + "" + h3 + "" + h2 + "" + h1 + "" + h0);
                        }
                        buf.append((char)charVal);
                        continue block14;
                    }
                }
                throw new Parser.ParseException(this, "Invalid escape sequence: \\" + c);
            }
            if (c == '\"') break;
            buf.append(c);
        }
        this.skipWhitespace();
        return buf.toString();
    }

    private Object parseNumber() throws Parser.ParseException {
        boolean hasExponentPart;
        boolean hasFractionalPart;
        char c;
        int startIdx = this.getPosition();
        if (this.peek() == '-') {
            this.next();
        }
        int integralStartIdx = this.getPosition();
        while (this.hasMore() && (c = this.peek()) >= '0' && c <= '9') {
            this.next();
        }
        int integralEndIdx = this.getPosition();
        int numIntegralDigits = integralEndIdx - integralStartIdx;
        if (numIntegralDigits == 0) {
            throw new Parser.ParseException(this, "Expected a number");
        }
        boolean bl = hasFractionalPart = this.peek() == '.';
        if (hasFractionalPart) {
            char c2;
            this.next();
            while (this.hasMore() && (c2 = this.peek()) >= '0' && c2 <= '9') {
                this.next();
            }
            if (this.getPosition() - (integralEndIdx + 1) == 0) {
                throw new Parser.ParseException(this, "Expected digits after decimal point");
            }
        }
        boolean bl2 = hasExponentPart = this.peek() == '.';
        if (hasExponentPart) {
            char c3;
            this.next();
            char sign = this.peek();
            if (sign == '-' || sign == '+') {
                this.next();
            }
            int exponentStart = this.getPosition();
            while (this.hasMore() && (c3 = this.peek()) >= '0' && c3 <= '9') {
                this.next();
            }
            if (this.getPosition() - exponentStart == 0) {
                throw new Parser.ParseException(this, "Expected an exponent");
            }
        }
        int endIdx = this.getPosition();
        String numberStr = this.getSubstring(startIdx, endIdx).toString();
        if (hasFractionalPart || hasExponentPart) {
            return Double.valueOf(numberStr);
        }
        if (numIntegralDigits < 9) {
            return Integer.valueOf(numberStr);
        }
        if (numIntegralDigits == 9) {
            long longVal = Long.parseLong(numberStr);
            if (longVal >= Integer.MIN_VALUE && longVal < Integer.MAX_VALUE) {
                return (int)longVal;
            }
            return longVal;
        }
        return Long.valueOf(numberStr);
    }

    private JSONArray parseJSONArray() throws Parser.ParseException {
        this.expect('[');
        this.skipWhitespace();
        if (this.peek() == ']') {
            this.next();
            return new JSONArray(Collections.emptyList());
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        boolean first = true;
        while (this.peek() != ']') {
            if (first) {
                first = false;
            } else {
                this.expect(',');
            }
            elements.add(this.parseJSON());
        }
        this.expect(']');
        return new JSONArray(elements);
    }

    private JSONObject parseJSONObject() throws Parser.ParseException {
        this.expect('{');
        this.skipWhitespace();
        if (this.peek() == '}') {
            this.next();
            return new JSONObject(Collections.emptyList());
        }
        ArrayList<Map.Entry<String, Object>> kvPairs = new ArrayList<Map.Entry<String, Object>>();
        JSONObject jsonObject = new JSONObject(kvPairs);
        boolean first = true;
        while (this.peek() != '}') {
            if (first) {
                first = false;
            } else {
                this.expect(',');
            }
            CharSequence key = this.parseString();
            if (key == null) {
                throw new Parser.ParseException(this, "Object keys must be strings");
            }
            if (this.peek() != ':') {
                return null;
            }
            this.expect(':');
            Object value = this.parseJSON();
            if (key.equals("__ID")) {
                if (value == null) {
                    throw new Parser.ParseException(this, "Got null value for \"__ID\" key");
                }
                jsonObject.objectId = (CharSequence)value;
                continue;
            }
            kvPairs.add(new AbstractMap.SimpleEntry<String, Object>(key.toString(), value));
        }
        this.expect('}');
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseJSON() throws Parser.ParseException {
        this.skipWhitespace();
        try {
            char c = this.peek();
            if (c == '{') {
                JSONObject jSONObject = this.parseJSONObject();
                return jSONObject;
            }
            if (c == '[') {
                JSONArray jSONArray = this.parseJSONArray();
                return jSONArray;
            }
            if (c == '\"') {
                CharSequence charSequence = this.parseString();
                if (charSequence == null) {
                    throw new Parser.ParseException(this, "Invalid string");
                }
                CharSequence charSequence2 = charSequence;
                return charSequence2;
            }
            if (this.peekMatches("true")) {
                this.advance(4);
                Boolean bl = true;
                return bl;
            }
            if (this.peekMatches("false")) {
                this.advance(5);
                Boolean bl = false;
                return bl;
            }
            if (this.peekMatches("null")) {
                this.advance(4);
                Object var2_7 = null;
                return var2_7;
            }
            Object object = this.parseNumber();
            return object;
        }
        finally {
            this.skipWhitespace();
        }
    }

    static Object parseJSON(String str) throws Parser.ParseException {
        return new JSONParser(str).parseJSON();
    }
}

