/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.ClassGraph;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class VersionFinder {
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final int JAVA_MAJOR_VERSION;
    public static final OperatingSystem OS;
    private static final String MAVEN_PACKAGE = "io.github.classgraph";
    private static final String MAVEN_ARTIFACT = "classgraph";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final synchronized String getVersion() {
        Object classfileName;
        Class<ClassGraph> cls;
        block25: {
            cls = ClassGraph.class;
            try {
                int i;
                String className = cls.getName();
                classfileName = "/" + className.replace('.', '/') + ".class";
                URL classpathResource = cls.getResource((String)classfileName);
                if (classpathResource == null) break block25;
                Path absolutePackagePath = Paths.get(classpathResource.toURI()).getParent();
                int packagePathSegments = className.length() - className.replace(".", "").length();
                Path path = absolutePackagePath;
                int segmentsToRemove = packagePathSegments;
                for (i = 0; i < segmentsToRemove && path != null; path = path.getParent(), ++i) {
                }
                for (i = 0; i < 3 && path != null; ++i, path = path.getParent()) {
                    Path pom = path.resolve("pom.xml");
                    try (InputStream is = Files.newInputStream(pom, new OpenOption[0]);){
                        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
                        doc.getDocumentElement().normalize();
                        String version = (String)XPathFactory.newInstance().newXPath().compile("/project/version").evaluate(doc, XPathConstants.STRING);
                        if (version == null || (version = version.trim()).isEmpty()) continue;
                        String string = version;
                        return string;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception className) {
                // empty catch block
            }
        }
        try {
            InputStream is = cls.getResourceAsStream("/META-INF/maven/io.github.classgraph/classgraph/pom.properties");
            classfileName = null;
            try {
                if (is != null) {
                    Properties p = new Properties();
                    p.load(is);
                    String version = p.getProperty("version", "").trim();
                    if (!version.isEmpty()) {
                        String string = version;
                        return string;
                    }
                }
            }
            catch (Throwable throwable) {
                classfileName = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    VersionFinder.$closeResource((Throwable)classfileName, is);
                }
            }
        }
        catch (Exception is) {
            // empty catch block
        }
        Package pkg = cls.getPackage();
        if (pkg == null) return "unknown";
        String version = pkg.getImplementationVersion();
        if (version == null) {
            version = "";
        }
        if ((version = version.trim()).isEmpty()) {
            version = pkg.getSpecificationVersion();
            if (version == null) {
                version = "";
            }
            version = version.trim();
        }
        if (version.isEmpty()) return "unknown";
        return version;
    }

    static {
        int javaMajorVersion = 0;
        if (JAVA_VERSION != null) {
            for (String versionPart : JAVA_VERSION.split("[^0-9]+")) {
                if (versionPart.isEmpty() || versionPart.equals("1")) continue;
                javaMajorVersion = Integer.parseInt(versionPart);
                break;
            }
        }
        JAVA_MAJOR_VERSION = javaMajorVersion;
        String osName = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH);
        OS = osName.indexOf("mac") >= 0 || osName.indexOf("darwin") >= 0 ? OperatingSystem.MacOSX : (osName.indexOf("win") >= 0 ? OperatingSystem.Windows : (osName.indexOf("nux") >= 0 ? OperatingSystem.Linux : OperatingSystem.Unknown));
    }

    public static enum OperatingSystem {
        Windows,
        MacOSX,
        Linux,
        Unknown;

    }
}

