/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.data.cluster;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.zeebe.protocol.impl.Loggers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;

public class BrokerInfo {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String PROPERTY_NAME = "brokerInfo";
    public static final String COMMAND_API_PROPERTY = "command";
    private int nodeId;
    private int partitionsCount;
    private int clusterSize;
    private int replicationFactor;
    private final Map<String, String> addresses = new HashMap<String, String>();
    private final Map<Integer, Boolean> partitionRoles = new HashMap<Integer, Boolean>();

    public static BrokerInfo fromProperties(Properties properties) {
        BrokerInfo brokerInfo = null;
        String property = properties.getProperty(PROPERTY_NAME);
        if (property != null) {
            try {
                brokerInfo = (BrokerInfo)OBJECT_MAPPER.readValue(property, BrokerInfo.class);
            }
            catch (IOException e) {
                Loggers.PROTOCOL_LOGGER.warn("Failed to deserialize broker info from property: {}", (Object)property, (Object)e);
            }
        }
        return brokerInfo;
    }

    public static void writeIntoProperties(Properties memberProperties, BrokerInfo distributionInfo) {
        try {
            memberProperties.setProperty(PROPERTY_NAME, OBJECT_MAPPER.writeValueAsString((Object)distributionInfo));
        }
        catch (JsonProcessingException e) {
            Loggers.PROTOCOL_LOGGER.error("Couldn't write broker info {} into member properties {}", new Object[]{distributionInfo, memberProperties, e});
        }
    }

    public BrokerInfo() {
    }

    public BrokerInfo(int nodeId, int partitionsCount, int clusterSize, int replicationFactor) {
        this();
        this.nodeId = nodeId;
        this.partitionsCount = partitionsCount;
        this.clusterSize = clusterSize;
        this.replicationFactor = replicationFactor;
    }

    public void setApiAddress(String apiName, String address) {
        this.addresses.put(apiName, address);
    }

    public Set<Integer> getPartitions() {
        return this.partitionRoles.keySet();
    }

    public void addLeaderForPartition(int partition) {
        this.partitionRoles.put(partition, true);
    }

    public void addFollowerForPartition(int partition) {
        this.partitionRoles.put(partition, false);
    }

    public BrokerInfo consumePartitions(Consumer<Integer> leaderPartitionConsumer, Consumer<Integer> followerPartitionsConsumer) {
        return this.consumePartitions(p -> {}, leaderPartitionConsumer, followerPartitionsConsumer);
    }

    public BrokerInfo consumePartitions(Consumer<Integer> partitionConsumer, Consumer<Integer> leaderPartitionConsumer, Consumer<Integer> followerPartitionsConsumer) {
        this.partitionRoles.forEach((partition, state) -> {
            partitionConsumer.accept((Integer)partition);
            if (state.booleanValue()) {
                leaderPartitionConsumer.accept((Integer)partition);
            } else {
                followerPartitionsConsumer.accept((Integer)partition);
            }
        });
        return this;
    }

    public String getApiAddress(String apiName) {
        return this.addresses.get(apiName);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public void clearPartitions() {
        this.partitionRoles.clear();
    }

    public String toString() {
        return "BrokerInfo{nodeId=" + this.nodeId + ", partitionsCount=" + this.partitionsCount + ", clusterSize=" + this.clusterSize + ", replicationFactor=" + this.replicationFactor + ", addresses=" + this.addresses + ", partitionRoles=" + this.partitionRoles + '}';
    }

    static {
        OBJECT_MAPPER.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        OBJECT_MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }
}

