/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.encoding;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.zeebe.protocol.record.JsonSerializable;
import io.zeebe.util.StringUtil;
import io.zeebe.util.buffer.BufferUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public final class MsgPackConverter {
    private static final JsonEncoding JSON_ENCODING = JsonEncoding.UTF8;
    private static final Charset JSON_CHARSET = StandardCharsets.UTF_8;
    private static final JsonFactory MESSAGE_PACK_FACTORY = new MessagePackFactory().setReuseResourceInGenerator(false).setReuseResourceInParser(false);
    private static final JsonFactory JSON_FACTORY = new MappingJsonFactory().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper(JSON_FACTORY);
    private static final ObjectMapper MESSSAGE_PACK_OBJECT_MAPPER = new ObjectMapper(MESSAGE_PACK_FACTORY);

    private MsgPackConverter() {
    }

    public static byte[] convertToMsgPack(String json) {
        byte[] jsonBytes = StringUtil.getBytes((String)json, (Charset)JSON_CHARSET);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonBytes);
        return MsgPackConverter.convertToMsgPack(inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] convertToMsgPack(InputStream inputStream) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            MsgPackConverter.convert(inputStream, outputStream, JSON_FACTORY, MESSAGE_PACK_FACTORY);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert JSON to MessagePack", e);
        }
    }

    public static String convertToJson(DirectBuffer buffer) {
        return MsgPackConverter.convertToJson(BufferUtil.bufferAsArray((DirectBuffer)buffer));
    }

    public static String convertToJson(byte[] msgPack) {
        return MsgPackConverter.convertToJson(new ByteArrayInputStream(msgPack));
    }

    public static String convertToJson(InputStream msgPackInputStream) {
        byte[] jsonBytes = MsgPackConverter.convertToJsonBytes(msgPackInputStream);
        return new String(jsonBytes, JSON_CHARSET);
    }

    public static InputStream convertToJsonInputStream(byte[] msgPack) {
        byte[] jsonBytes = MsgPackConverter.convertToJsonBytes(msgPack);
        return new ByteArrayInputStream(jsonBytes);
    }

    private static byte[] convertToJsonBytes(byte[] msgPack) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(msgPack);
        return MsgPackConverter.convertToJsonBytes(inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] convertToJsonBytes(InputStream msgPackInputStream) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            MsgPackConverter.convert(msgPackInputStream, outputStream, MESSAGE_PACK_FACTORY, JSON_FACTORY);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert MessagePack to JSON", e);
        }
    }

    private static void convert(InputStream in, OutputStream out, JsonFactory inFormat, JsonFactory outFormat) throws Exception {
        JsonParser parser = inFormat.createParser(in);
        JsonGenerator generator = outFormat.createGenerator(out, JSON_ENCODING);
        JsonToken token = parser.nextToken();
        if (!token.isStructStart() && !token.isScalarValue()) {
            throw new RuntimeException("Document does not begin with an object, an array, or a scalar value");
        }
        generator.copyCurrentStructure(parser);
        if (parser.nextToken() != null) {
            throw new RuntimeException("Document has more content than a single object/array");
        }
        generator.flush();
    }

    public static Map<String, Object> convertToMap(DirectBuffer buffer) {
        byte[] msgpackBytes = BufferUtil.bufferAsArray((DirectBuffer)buffer);
        byte[] jsonBytes = MsgPackConverter.convertToJsonBytes(new ByteArrayInputStream(msgpackBytes));
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try {
            return (Map)JSON_OBJECT_MAPPER.readValue(jsonBytes, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] convertToMsgPack(Object value) {
        try {
            return MESSSAGE_PACK_OBJECT_MAPPER.writeValueAsBytes(value);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to serialize object '%s' to Msgpack", value), e);
        }
    }

    public static String convertJsonSerializableObjectToJson(JsonSerializable recordValue) {
        try {
            return JSON_OBJECT_MAPPER.writeValueAsString((Object)recordValue);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

