/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.JsonSerializable;
import io.zeebe.protocol.record.Record;
import java.time.Instant;

public class CopiedRecord<T extends UnifiedRecordValue>
implements Record<T> {
    private final T recordValue;
    private final RecordMetadata metadata;
    private final long key;
    private final long position;
    private final long sourcePosition;
    private final long timestamp;
    private final int producerId;

    public CopiedRecord(T recordValue, RecordMetadata recordMetadata, long key, long position, long sourcePosition, long timestamp, int producerId) {
        this.metadata = recordMetadata;
        this.recordValue = recordValue;
        this.key = key;
        this.position = position;
        this.sourcePosition = sourcePosition;
        this.timestamp = timestamp;
        this.producerId = producerId;
    }

    public long getPosition() {
        return this.position;
    }

    public long getSourceRecordPosition() {
        return this.sourcePosition;
    }

    public long getKey() {
        return this.key;
    }

    @JsonProperty(value="timestamp")
    public long getTimestampLong() {
        return this.timestamp;
    }

    @JsonIgnore
    public Instant getTimestamp() {
        return Instant.ofEpochMilli(this.timestamp);
    }

    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    public int getProducerId() {
        return this.producerId;
    }

    public T getValue() {
        return this.recordValue;
    }

    public String toJson() {
        return MsgPackConverter.convertJsonSerializableObjectToJson((JsonSerializable)this);
    }
}

