/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.record.JsonSerializable;
import io.zeebe.protocol.record.MessageHeaderDecoder;
import io.zeebe.protocol.record.MessageHeaderEncoder;
import io.zeebe.protocol.record.RecordMetadataDecoder;
import io.zeebe.protocol.record.RecordMetadataEncoder;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferUtil;
import io.zeebe.util.buffer.BufferWriter;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class RecordMetadata
implements BufferWriter,
BufferReader,
io.zeebe.protocol.record.RecordMetadata {
    public static final int BLOCK_LENGTH = 28;
    protected final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    protected final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    protected RecordMetadataEncoder encoder = new RecordMetadataEncoder();
    protected RecordMetadataDecoder decoder = new RecordMetadataDecoder();
    private RecordType recordType = RecordType.NULL_VAL;
    private short intentValue = (short)255;
    private Intent intent = null;
    private int partitionId;
    private int requestStreamId;
    protected long requestId;
    private int protocolVersion = 1;
    protected ValueType valueType = ValueType.NULL_VAL;
    private RejectionType rejectionType;
    private final UnsafeBuffer rejectionReason = new UnsafeBuffer(0L, 0);

    public RecordMetadata() {
        this.reset();
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.reset();
        this.headerDecoder.wrap(buffer, offset);
        this.decoder.wrap(buffer, offset += this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        this.partitionId = this.decoder.partitionId();
        this.recordType = this.decoder.recordType();
        this.requestStreamId = this.decoder.requestStreamId();
        this.requestId = this.decoder.requestId();
        this.protocolVersion = this.decoder.protocolVersion();
        this.valueType = this.decoder.valueType();
        this.intent = Intent.fromProtocolValue((ValueType)this.valueType, (short)this.decoder.intent());
        this.rejectionType = this.decoder.rejectionType();
        int rejectionReasonLength = this.decoder.rejectionReasonLength();
        if (rejectionReasonLength > 0) {
            offset += this.headerDecoder.blockLength();
            this.rejectionReason.wrap(buffer, offset += RecordMetadataDecoder.rejectionReasonHeaderLength(), rejectionReasonLength);
        }
    }

    @JsonIgnore
    public int getLength() {
        return 28 + RecordMetadataEncoder.rejectionReasonHeaderLength() + this.rejectionReason.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset);
        this.headerEncoder.blockLength(this.encoder.sbeBlockLength()).templateId(this.encoder.sbeTemplateId()).schemaId(this.encoder.sbeSchemaId()).version(this.encoder.sbeSchemaVersion());
        this.encoder.wrap(buffer, offset += this.headerEncoder.encodedLength());
        this.encoder.partitionId(this.partitionId).recordType(this.recordType).requestStreamId(this.requestStreamId).requestId(this.requestId).protocolVersion(this.protocolVersion).valueType(this.valueType).intent(this.intentValue).rejectionType(this.rejectionType);
        offset += 20;
        if (this.rejectionReason.capacity() > 0) {
            this.encoder.putRejectionReason((DirectBuffer)this.rejectionReason, 0, this.rejectionReason.capacity());
        } else {
            buffer.putShort(offset, (short)0);
        }
    }

    @JsonIgnore
    public long getRequestId() {
        return this.requestId;
    }

    public RecordMetadata requestId(long requestId) {
        this.requestId = requestId;
        return this;
    }

    @JsonIgnore
    public int getRequestStreamId() {
        return this.requestStreamId;
    }

    public RecordMetadata requestStreamId(int requestStreamId) {
        this.requestStreamId = requestStreamId;
        return this;
    }

    public RecordMetadata protocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
        return this;
    }

    @JsonIgnore
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public RecordMetadata valueType(ValueType eventType) {
        this.valueType = eventType;
        return this;
    }

    public RecordMetadata intent(Intent intent) {
        this.intent = intent;
        this.intentValue = intent.value();
        return this;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public RecordMetadata recordType(RecordType recordType) {
        this.recordType = recordType;
        return this;
    }

    public RecordType getRecordType() {
        return this.recordType;
    }

    public RecordMetadata rejectionType(RejectionType rejectionType) {
        this.rejectionType = rejectionType;
        return this;
    }

    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    public RecordMetadata rejectionReason(String rejectionReason) {
        byte[] bytes = rejectionReason.getBytes(StandardCharsets.UTF_8);
        this.rejectionReason.wrap(bytes);
        return this;
    }

    public RecordMetadata rejectionReason(DirectBuffer buffer) {
        this.rejectionReason.wrap(buffer);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getRejectionReasonBuffer() {
        return this.rejectionReason;
    }

    public RecordMetadata partitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public String getRejectionReason() {
        return BufferUtil.bufferAsString((DirectBuffer)this.rejectionReason);
    }

    public String toJson() {
        return MsgPackConverter.convertJsonSerializableObjectToJson((JsonSerializable)this);
    }

    public RecordMetadata reset() {
        this.partitionId = RecordMetadataEncoder.partitionIdNullValue();
        this.recordType = RecordType.NULL_VAL;
        this.requestId = RecordMetadataEncoder.requestIdNullValue();
        this.requestStreamId = RecordMetadataEncoder.requestStreamIdNullValue();
        this.protocolVersion = 1;
        this.valueType = ValueType.NULL_VAL;
        this.intentValue = (short)255;
        this.intent = null;
        this.rejectionType = RejectionType.NULL_VAL;
        this.rejectionReason.wrap(0L, 0);
        return this;
    }

    public boolean hasRequestMetadata() {
        return this.requestId != RecordMetadataEncoder.requestIdNullValue() && this.requestStreamId != RecordMetadataEncoder.requestStreamIdNullValue();
    }

    public String toString() {
        return "RecordMetadata{partitionId=" + this.partitionId + ", recordType=" + this.recordType + ", intentValue=" + this.intentValue + ", intent=" + this.intent + ", requestStreamId=" + this.requestStreamId + ", requestId=" + this.requestId + ", protocolVersion=" + this.protocolVersion + ", valueType=" + this.valueType + ", rejectionType=" + this.rejectionType + ", rejectionReason=" + BufferUtil.bufferAsString((DirectBuffer)this.rejectionReason) + '}';
    }
}

