/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.deployment;

import io.zeebe.msgpack.property.ArrayProperty;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.value.BaseValue;
import io.zeebe.msgpack.value.ValueArray;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.zeebe.protocol.impl.record.value.deployment.Workflow;
import io.zeebe.protocol.record.value.DeploymentRecordValue;
import io.zeebe.protocol.record.value.deployment.DeployedWorkflow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class DeploymentRecord
extends UnifiedRecordValue
implements DeploymentRecordValue {
    public static final String RESOURCES = "resources";
    public static final String WORKFLOWS = "deployedWorkflows";
    private final ArrayProperty<DeploymentResource> resourcesProp = new ArrayProperty("resources", (BaseValue)new DeploymentResource());
    private final ArrayProperty<Workflow> workflowsProp = new ArrayProperty("deployedWorkflows", (BaseValue)new Workflow());

    public DeploymentRecord() {
        this.declareProperty((BaseProperty)this.resourcesProp).declareProperty(this.workflowsProp);
    }

    public ValueArray<Workflow> workflows() {
        return this.workflowsProp;
    }

    public ValueArray<DeploymentResource> resources() {
        return this.resourcesProp;
    }

    public List<io.zeebe.protocol.record.value.deployment.DeploymentResource> getResources() {
        ArrayList<io.zeebe.protocol.record.value.deployment.DeploymentResource> resources = new ArrayList<io.zeebe.protocol.record.value.deployment.DeploymentResource>();
        Iterator iterator = this.resourcesProp.iterator();
        iterator.forEachRemaining(resources::add);
        return resources;
    }

    public List<DeployedWorkflow> getDeployedWorkflows() {
        ArrayList<DeployedWorkflow> workflows = new ArrayList<DeployedWorkflow>();
        for (Workflow workflow : this.workflowsProp) {
            byte[] bytes = new byte[workflow.getLength()];
            UnsafeBuffer copyBuffer = new UnsafeBuffer(bytes);
            workflow.write((MutableDirectBuffer)copyBuffer, 0);
            Workflow copiedWorkflow = new Workflow();
            copiedWorkflow.wrap((DirectBuffer)copyBuffer);
            workflows.add(copiedWorkflow);
        }
        return workflows;
    }
}

