/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.job;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.DocumentProperty;
import io.zeebe.msgpack.property.IntegerProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.ObjectProperty;
import io.zeebe.msgpack.property.PackedProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.msgpack.spec.MsgPackHelper;
import io.zeebe.msgpack.value.ObjectValue;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.impl.record.value.job.JobHeaders;
import io.zeebe.protocol.record.intent.WorkflowInstanceRelated;
import io.zeebe.protocol.record.value.JobRecordValue;
import io.zeebe.protocol.record.value.job.Headers;
import io.zeebe.util.buffer.BufferUtil;
import java.time.Instant;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class JobRecord
extends UnifiedRecordValue
implements WorkflowInstanceRelated,
JobRecordValue {
    public static final DirectBuffer NO_HEADERS = new UnsafeBuffer(MsgPackHelper.EMTPY_OBJECT);
    private static final String RETRIES = "retries";
    private static final String TYPE = "type";
    private static final String CUSTOM_HEADERS = "customHeaders";
    private static final String VARIABLES = "variables";
    private static final String ERROR_MESSAGE = "errorMessage";
    private final LongProperty deadlineProp = new LongProperty("deadline", Long.MIN_VALUE);
    private final StringProperty workerProp = new StringProperty("worker", "");
    private final IntegerProperty retriesProp = new IntegerProperty("retries", -1);
    private final StringProperty typeProp = new StringProperty("type", "");
    private final ObjectProperty<JobHeaders> headersProp = new ObjectProperty("headers", (ObjectValue)new JobHeaders());
    private final PackedProperty customHeadersProp = new PackedProperty("customHeaders", NO_HEADERS);
    private final DocumentProperty variableProp = new DocumentProperty("variables");
    private final StringProperty errorMessageProp = new StringProperty("errorMessage", "");

    public JobRecord() {
        this.declareProperty((BaseProperty)this.deadlineProp).declareProperty((BaseProperty)this.workerProp).declareProperty((BaseProperty)this.retriesProp).declareProperty((BaseProperty)this.typeProp).declareProperty(this.headersProp).declareProperty((BaseProperty)this.customHeadersProp).declareProperty((BaseProperty)this.variableProp).declareProperty((BaseProperty)this.errorMessageProp);
    }

    public JobRecord resetVariables() {
        this.variableProp.reset();
        return this;
    }

    @JsonIgnore
    public DirectBuffer getCustomHeadersBuffer() {
        return this.customHeadersProp.getValue();
    }

    @JsonProperty(value="deadline")
    public long getDeadlineLong() {
        return this.deadlineProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getErrorMessageBuffer() {
        return this.errorMessageProp.getValue();
    }

    @JsonIgnore
    public JobHeaders getJobHeaders() {
        return (JobHeaders)this.headersProp.getValue();
    }

    public String getType() {
        return BufferUtil.bufferAsString((DirectBuffer)this.typeProp.getValue());
    }

    public Headers getHeaders() {
        return (Headers)this.headersProp.getValue();
    }

    public Map<String, Object> getCustomHeaders() {
        return MsgPackConverter.convertToMap(this.customHeadersProp.getValue());
    }

    public String getWorker() {
        return BufferUtil.bufferAsString((DirectBuffer)this.workerProp.getValue());
    }

    public int getRetries() {
        return this.retriesProp.getValue();
    }

    @JsonIgnore
    public Instant getDeadline() {
        return Instant.ofEpochMilli(this.deadlineProp.getValue());
    }

    public String getErrorMessage() {
        return BufferUtil.bufferAsString((DirectBuffer)this.errorMessageProp.getValue());
    }

    @JsonIgnore
    public DirectBuffer getTypeBuffer() {
        return this.typeProp.getValue();
    }

    public String getVariables() {
        return MsgPackConverter.convertToJson(this.variableProp.getValue());
    }

    @JsonIgnore
    public Map<String, Object> getVariablesAsMap() {
        return MsgPackConverter.convertToMap(this.variableProp.getValue());
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variableProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getWorkerBuffer() {
        return this.workerProp.getValue();
    }

    @JsonIgnore
    public long getWorkflowInstanceKey() {
        return ((JobHeaders)this.headersProp.getValue()).getWorkflowInstanceKey();
    }

    public JobRecord setCustomHeaders(DirectBuffer buffer) {
        this.customHeadersProp.setValue(buffer, 0, buffer.capacity());
        return this;
    }

    public JobRecord setDeadline(long val) {
        this.deadlineProp.setValue(val);
        return this;
    }

    public JobRecord setErrorMessage(String errorMessage) {
        this.errorMessageProp.setValue(errorMessage);
        return this;
    }

    public JobRecord setErrorMessage(DirectBuffer buf) {
        return this.setErrorMessage(buf, 0, buf.capacity());
    }

    public JobRecord setErrorMessage(DirectBuffer buf, int offset, int length) {
        this.errorMessageProp.setValue(buf, offset, length);
        return this;
    }

    public JobRecord setRetries(int retries) {
        this.retriesProp.setValue(retries);
        return this;
    }

    public JobRecord setType(String type) {
        this.typeProp.setValue(type);
        return this;
    }

    public JobRecord setType(DirectBuffer buf) {
        return this.setType(buf, 0, buf.capacity());
    }

    public JobRecord setType(DirectBuffer buf, int offset, int length) {
        this.typeProp.setValue(buf, offset, length);
        return this;
    }

    public JobRecord setVariables(DirectBuffer variables) {
        this.variableProp.setValue(variables);
        return this;
    }

    public JobRecord setWorker(String worker) {
        this.workerProp.setValue(worker);
        return this;
    }

    public JobRecord setWorker(DirectBuffer worker) {
        return this.setWorker(worker, 0, worker.capacity());
    }

    public JobRecord setWorker(DirectBuffer worker, int offset, int length) {
        this.workerProp.setValue(worker, offset, length);
        return this;
    }
}

