/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.DocumentProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.value.MessageRecordValue;
import io.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public class MessageRecord
extends UnifiedRecordValue
implements MessageRecordValue {
    private final StringProperty nameProp = new StringProperty("name");
    private final StringProperty correlationKeyProp = new StringProperty("correlationKey");
    private final LongProperty timeToLiveProp = new LongProperty("timeToLive");
    private final DocumentProperty variablesProp = new DocumentProperty("variables");
    private final StringProperty messageIdProp = new StringProperty("messageId", "");

    public MessageRecord() {
        this.declareProperty((BaseProperty)this.nameProp).declareProperty((BaseProperty)this.correlationKeyProp).declareProperty((BaseProperty)this.timeToLiveProp).declareProperty((BaseProperty)this.variablesProp).declareProperty((BaseProperty)this.messageIdProp);
    }

    public boolean hasMessageId() {
        return this.messageIdProp.getValue().capacity() > 0;
    }

    @JsonIgnore
    public DirectBuffer getCorrelationKeyBuffer() {
        return this.correlationKeyProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getMessageIdBuffer() {
        return this.messageIdProp.getValue();
    }

    public String getName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.nameProp.getValue());
    }

    public String getCorrelationKey() {
        return BufferUtil.bufferAsString((DirectBuffer)this.correlationKeyProp.getValue());
    }

    public String getMessageId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.messageIdProp.getValue());
    }

    public long getTimeToLive() {
        return this.timeToLiveProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getNameBuffer() {
        return this.nameProp.getValue();
    }

    public String getVariables() {
        return MsgPackConverter.convertToJson(this.variablesProp.getValue());
    }

    @JsonIgnore
    public Map<String, Object> getVariablesAsMap() {
        return MsgPackConverter.convertToMap(this.variablesProp.getValue());
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProp.getValue();
    }

    public MessageRecord setCorrelationKey(String correlationKey) {
        this.correlationKeyProp.setValue(correlationKey);
        return this;
    }

    public MessageRecord setCorrelationKey(DirectBuffer correlationKey) {
        this.correlationKeyProp.setValue(correlationKey);
        return this;
    }

    public MessageRecord setMessageId(String messageId) {
        this.messageIdProp.setValue(messageId);
        return this;
    }

    public MessageRecord setMessageId(DirectBuffer messageId) {
        this.messageIdProp.setValue(messageId);
        return this;
    }

    public MessageRecord setName(String name) {
        this.nameProp.setValue(name);
        return this;
    }

    public MessageRecord setName(DirectBuffer name) {
        this.nameProp.setValue(name);
        return this;
    }

    public MessageRecord setTimeToLive(long timeToLive) {
        this.timeToLiveProp.setValue(timeToLive);
        return this;
    }

    public MessageRecord setVariables(DirectBuffer variables) {
        this.variablesProp.setValue(variables);
        return this;
    }
}

