/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.variable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.DocumentProperty;
import io.zeebe.msgpack.property.EnumProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import java.util.Map;
import java.util.Objects;
import org.agrona.DirectBuffer;

public class VariableDocumentRecord
extends UnifiedRecordValue
implements VariableDocumentRecordValue {
    private final LongProperty scopeKeyProperty = new LongProperty("scopeKey");
    private final EnumProperty<VariableDocumentUpdateSemantic> updateSemanticsProperty = new EnumProperty("updateSemantics", VariableDocumentUpdateSemantic.class, (Enum)VariableDocumentUpdateSemantic.PROPAGATE);
    private final DocumentProperty documentProperty = new DocumentProperty("document");

    public VariableDocumentRecord() {
        this.declareProperty((BaseProperty)this.scopeKeyProperty).declareProperty(this.updateSemanticsProperty).declareProperty((BaseProperty)this.documentProperty);
    }

    public VariableDocumentRecord wrap(VariableDocumentRecord other) {
        this.setScopeKey(other.getScopeKey()).setDocument(other.getDocumentBuffer()).setUpdateSemantics(other.getUpdateSemantics());
        return this;
    }

    public long getScopeKey() {
        return this.scopeKeyProperty.getValue();
    }

    public VariableDocumentUpdateSemantic getUpdateSemantics() {
        return (VariableDocumentUpdateSemantic)this.updateSemanticsProperty.getValue();
    }

    public Map<String, Object> getDocument() {
        return MsgPackConverter.convertToMap(this.documentProperty.getValue());
    }

    public VariableDocumentRecord setScopeKey(long scopeKey) {
        this.scopeKeyProperty.setValue(scopeKey);
        return this;
    }

    public VariableDocumentRecord setUpdateSemantics(VariableDocumentUpdateSemantic updateSemantics) {
        this.updateSemanticsProperty.setValue((Enum)updateSemantics);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getDocumentBuffer() {
        return this.documentProperty.getValue();
    }

    public VariableDocumentRecord setDocument(DirectBuffer document) {
        this.documentProperty.setValue(document);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VariableDocumentRecord)) {
            return false;
        }
        VariableDocumentRecord that = (VariableDocumentRecord)((Object)o);
        return Objects.equals(this.scopeKeyProperty, that.scopeKeyProperty) && Objects.equals(this.updateSemanticsProperty, that.updateSemanticsProperty) && Objects.equals(this.documentProperty, that.documentProperty);
    }

    public int hashCode() {
        return Objects.hash(this.scopeKeyProperty, this.updateSemanticsProperty, this.documentProperty);
    }

    public String toString() {
        return "VariableDocumentRecord{scopeKey=" + this.getScopeKey() + ", mergeSemantics=" + this.getUpdateSemantics() + ", document=" + this.getDocumentBuffer() + "} " + super.toString();
    }
}

