/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.protocol.impl.record.value.workflowinstance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.EnumProperty;
import io.zeebe.msgpack.property.IntegerProperty;
import io.zeebe.msgpack.property.LongProperty;
import io.zeebe.msgpack.property.StringProperty;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.intent.WorkflowInstanceRelated;
import io.zeebe.protocol.record.value.BpmnElementType;
import io.zeebe.protocol.record.value.WorkflowInstanceRecordValue;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class WorkflowInstanceRecord
extends UnifiedRecordValue
implements WorkflowInstanceRelated,
WorkflowInstanceRecordValue {
    public static final String PROP_WORKFLOW_BPMN_PROCESS_ID = "bpmnProcessId";
    public static final String PROP_WORKFLOW_INSTANCE_KEY = "workflowInstanceKey";
    public static final String PROP_WORKFLOW_ELEMENT_ID = "elementId";
    public static final String PROP_WORKFLOW_VERSION = "version";
    public static final String PROP_WORKFLOW_KEY = "workflowKey";
    public static final String PROP_WORKFLOW_BPMN_TYPE = "bpmnElementType";
    public static final String PROP_WORKFLOW_SCOPE_KEY = "flowScopeKey";
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final IntegerProperty versionProp = new IntegerProperty("version", -1);
    private final LongProperty workflowKeyProp = new LongProperty("workflowKey", -1L);
    private final LongProperty workflowInstanceKeyProp = new LongProperty("workflowInstanceKey", -1L);
    private final StringProperty elementIdProp = new StringProperty("elementId", "");
    private final LongProperty flowScopeKeyProp = new LongProperty("flowScopeKey", -1L);
    private final EnumProperty<BpmnElementType> bpmnElementTypeProp = new EnumProperty("bpmnElementType", BpmnElementType.class, (Enum)BpmnElementType.UNSPECIFIED);

    public WorkflowInstanceRecord() {
        this.declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.versionProp).declareProperty((BaseProperty)this.workflowKeyProp).declareProperty((BaseProperty)this.workflowInstanceKeyProp).declareProperty((BaseProperty)this.elementIdProp).declareProperty((BaseProperty)this.flowScopeKeyProp).declareProperty(this.bpmnElementTypeProp);
    }

    public void wrap(WorkflowInstanceRecord record) {
        this.elementIdProp.setValue(record.getElementIdBuffer());
        this.bpmnProcessIdProp.setValue(record.getBpmnProcessIdBuffer());
        this.flowScopeKeyProp.setValue(record.getFlowScopeKey());
        this.versionProp.setValue(record.getVersion());
        this.workflowKeyProp.setValue(record.getWorkflowKey());
        this.workflowInstanceKeyProp.setValue(record.getWorkflowInstanceKey());
        this.bpmnElementTypeProp.setValue((Enum)record.getBpmnElementType());
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProp.getValue();
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKeyProp.getValue();
    }

    public WorkflowInstanceRecord setBpmnProcessId(DirectBuffer directBuffer, int offset, int length) {
        this.bpmnProcessIdProp.setValue(directBuffer, offset, length);
        return this;
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public int getVersion() {
        return this.versionProp.getValue();
    }

    public long getWorkflowKey() {
        return this.workflowKeyProp.getValue();
    }

    public String getElementId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.elementIdProp.getValue());
    }

    public long getFlowScopeKey() {
        return this.flowScopeKeyProp.getValue();
    }

    public BpmnElementType getBpmnElementType() {
        return (BpmnElementType)this.bpmnElementTypeProp.getValue();
    }

    public WorkflowInstanceRecord setBpmnElementType(BpmnElementType bpmnType) {
        this.bpmnElementTypeProp.setValue((Enum)bpmnType);
        return this;
    }

    public WorkflowInstanceRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public WorkflowInstanceRecord setBpmnProcessId(DirectBuffer directBuffer) {
        this.bpmnProcessIdProp.setValue(directBuffer);
        return this;
    }

    public WorkflowInstanceRecord setElementId(String elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public WorkflowInstanceRecord setElementId(DirectBuffer elementId) {
        return this.setElementId(elementId, 0, elementId.capacity());
    }

    public WorkflowInstanceRecord setElementId(DirectBuffer elementId, int offset, int length) {
        this.elementIdProp.setValue(elementId, offset, length);
        return this;
    }

    public WorkflowInstanceRecord setFlowScopeKey(long flowScopeKey) {
        this.flowScopeKeyProp.setValue(flowScopeKey);
        return this;
    }

    public WorkflowInstanceRecord setVersion(int version) {
        this.versionProp.setValue(version);
        return this;
    }

    public WorkflowInstanceRecord setWorkflowInstanceKey(long workflowInstanceKey) {
        this.workflowInstanceKeyProp.setValue(workflowInstanceKey);
        return this;
    }

    public WorkflowInstanceRecord setWorkflowKey(long workflowKey) {
        this.workflowKeyProp.setValue(workflowKey);
        return this;
    }
}

