/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor;

import io.zeebe.engine.processor.AsyncSnapshotDirector;
import io.zeebe.engine.processor.SnapshotMetrics;
import io.zeebe.engine.processor.StreamProcessor;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.spi.SnapshotController;
import io.zeebe.logstreams.state.StateSnapshotController;
import io.zeebe.servicecontainer.Injector;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.sched.Actor;
import java.time.Duration;

public class AsyncSnapshotingDirectorService
implements Service<AsyncSnapshotingDirectorService> {
    private final Injector<StreamProcessor> streamProcessorInjector = new Injector();
    private final int partitionId;
    private final LogStream logStream;
    private final StateSnapshotController snapshotController;
    private final Duration snapshotPeriod;
    private AsyncSnapshotDirector asyncSnapshotDirector;

    public AsyncSnapshotingDirectorService(int partitionId, LogStream logStream, StateSnapshotController snapshotController, Duration snapshotPeriod) {
        this.partitionId = partitionId;
        this.logStream = logStream;
        this.snapshotController = snapshotController;
        this.snapshotPeriod = snapshotPeriod;
    }

    public void start(ServiceStartContext startContext) {
        StreamProcessor streamProcessor = (StreamProcessor)((Object)this.streamProcessorInjector.getValue());
        SnapshotMetrics snapshotMetrics = new SnapshotMetrics(startContext.getScheduler().getMetricsManager(), streamProcessor.getName(), String.valueOf(this.partitionId));
        this.asyncSnapshotDirector = new AsyncSnapshotDirector(streamProcessor, (SnapshotController)this.snapshotController, this.logStream, this.snapshotPeriod, snapshotMetrics);
        startContext.getScheduler().submitActor((Actor)this.asyncSnapshotDirector);
    }

    public void stop(ServiceStopContext stopContext) {
        if (this.asyncSnapshotDirector != null) {
            stopContext.async(this.asyncSnapshotDirector.closeAsync());
            this.asyncSnapshotDirector = null;
        }
    }

    public AsyncSnapshotingDirectorService get() {
        return this;
    }

    public Injector<StreamProcessor> getStreamProcessorInjector() {
        return this.streamProcessorInjector;
    }
}

