/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor;

import io.zeebe.engine.processor.CommandProcessor;
import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.ReadonlyProcessingContext;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;

public class CommandProcessorImpl<T extends UnifiedRecordValue>
implements TypedRecordProcessor<T>,
CommandProcessor.CommandControl<T> {
    private final CommandProcessor<T> wrappedProcessor;
    private KeyGenerator keyGenerator;
    private boolean isAccepted;
    private long entityKey;
    private Intent newState;
    private T updatedValue;
    private RejectionType rejectionType;
    private String rejectionReason;

    public CommandProcessorImpl(CommandProcessor<T> commandProcessor) {
        this.wrappedProcessor = commandProcessor;
    }

    @Override
    public void onOpen(ReadonlyProcessingContext context) {
        this.keyGenerator = context.getZeebeState().getKeyGenerator();
    }

    @Override
    public void processRecord(TypedRecord<T> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        this.entityKey = command.getKey();
        this.wrappedProcessor.onCommand(command, this, streamWriter);
        boolean respond = command.getMetadata().hasRequestMetadata();
        if (this.isAccepted) {
            streamWriter.appendFollowUpEvent(this.entityKey, this.newState, (UnpackedObject)this.updatedValue);
            if (respond) {
                responseWriter.writeEventOnCommand(this.entityKey, this.newState, (UnpackedObject)this.updatedValue, command);
            }
        } else {
            streamWriter.appendRejection(command, this.rejectionType, this.rejectionReason);
            if (respond) {
                responseWriter.writeRejectionOnCommand(command, this.rejectionType, this.rejectionReason);
            }
        }
    }

    @Override
    public long accept(Intent newState, T updatedValue) {
        if (this.entityKey < 0L) {
            this.entityKey = this.keyGenerator.nextKey();
        }
        this.isAccepted = true;
        this.newState = newState;
        this.updatedValue = updatedValue;
        return this.entityKey;
    }

    @Override
    public void reject(RejectionType type, String reason) {
        this.isAccepted = false;
        this.rejectionType = type;
        this.rejectionReason = reason;
    }
}

