/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor;

import io.zeebe.engine.processor.TypedEventRegistry;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.protocol.impl.record.CopiedRecord;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.util.ReflectUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class CopiedRecords {
    public static CopiedRecord createCopiedRecord(LoggedEvent rawEvent) {
        DirectBuffer contentBuffer = rawEvent.getValueBuffer();
        byte[] metadataBytes = new byte[rawEvent.getMetadataLength()];
        contentBuffer.getBytes(rawEvent.getMetadataOffset(), metadataBytes);
        UnsafeBuffer metadataBuffer = new UnsafeBuffer(metadataBytes);
        RecordMetadata metadata = new RecordMetadata();
        metadata.wrap((DirectBuffer)metadataBuffer, 0, metadataBuffer.capacity());
        byte[] valueBytes = new byte[rawEvent.getValueLength()];
        contentBuffer.getBytes(rawEvent.getValueOffset(), valueBytes);
        UnsafeBuffer valueBuffer = new UnsafeBuffer(valueBytes);
        UnifiedRecordValue recordValue = (UnifiedRecordValue)ReflectUtil.newInstance(TypedEventRegistry.EVENT_REGISTRY.get(metadata.getValueType()));
        recordValue.wrap((DirectBuffer)valueBuffer);
        return new CopiedRecord(recordValue, metadata, rawEvent.getKey(), rawEvent.getPosition(), rawEvent.getSourceEventPosition(), rawEvent.getTimestamp(), rawEvent.getProducerId());
    }
}

