/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor;

import io.zeebe.db.DbContext;
import io.zeebe.engine.processor.CommandResponseWriter;
import io.zeebe.engine.processor.EventFilter;
import io.zeebe.engine.processor.ReadonlyProcessingContext;
import io.zeebe.engine.processor.RecordProcessorMap;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.util.metrics.MetricsManager;
import io.zeebe.util.sched.ActorControl;
import java.util.Map;
import java.util.function.BooleanSupplier;

public class ProcessingContext
implements ReadonlyProcessingContext {
    private ActorControl actor;
    private MetricsManager metricsManager;
    private int producerId;
    private String streamProcessorName;
    private EventFilter eventFilter;
    private LogStream logStream;
    private LogStreamReader logStreamReader;
    private TypedStreamWriter logStreamWriter;
    private CommandResponseWriter commandResponseWriter;
    private Map<ValueType, UnifiedRecordValue> eventCache;
    private RecordProcessorMap recordProcessorMap;
    private ZeebeState zeebeState;
    private DbContext dbContext;
    private BooleanSupplier abortCondition;

    public ProcessingContext actor(ActorControl actor) {
        this.actor = actor;
        return this;
    }

    public ProcessingContext eventFilter(EventFilter eventFilter) {
        this.eventFilter = eventFilter;
        return this;
    }

    public ProcessingContext logStream(LogStream logStream) {
        this.logStream = logStream;
        return this;
    }

    public ProcessingContext logStreamReader(LogStreamReader logStreamReader) {
        this.logStreamReader = logStreamReader;
        return this;
    }

    public ProcessingContext eventCache(Map<ValueType, UnifiedRecordValue> eventCache) {
        this.eventCache = eventCache;
        return this;
    }

    public ProcessingContext recordProcessorMap(RecordProcessorMap recordProcessorMap) {
        this.recordProcessorMap = recordProcessorMap;
        return this;
    }

    public ProcessingContext zeebeState(ZeebeState zeebeState) {
        this.zeebeState = zeebeState;
        return this;
    }

    public ProcessingContext dbContext(DbContext dbContext) {
        this.dbContext = dbContext;
        return this;
    }

    public ProcessingContext abortCondition(BooleanSupplier abortCondition) {
        this.abortCondition = abortCondition;
        return this;
    }

    public ProcessingContext producerId(int producerId) {
        this.producerId = producerId;
        return this;
    }

    public ProcessingContext streamProcessorName(String streamProcessorName) {
        this.streamProcessorName = streamProcessorName;
        return this;
    }

    public ProcessingContext logStreamWriter(TypedStreamWriter logStreamWriter) {
        this.logStreamWriter = logStreamWriter;
        return this;
    }

    public ProcessingContext commandResponseWriter(CommandResponseWriter commandResponseWriter) {
        this.commandResponseWriter = commandResponseWriter;
        return this;
    }

    public ProcessingContext metricsManager(MetricsManager metricsManager) {
        this.metricsManager = metricsManager;
        return this;
    }

    @Override
    public ActorControl getActor() {
        return this.actor;
    }

    @Override
    public int getProducerId() {
        return this.producerId;
    }

    @Override
    public String getStreamProcessorName() {
        return this.streamProcessorName;
    }

    @Override
    public EventFilter getEventFilter() {
        return this.eventFilter;
    }

    @Override
    public LogStream getLogStream() {
        return this.logStream;
    }

    @Override
    public LogStreamReader getLogStreamReader() {
        return this.logStreamReader;
    }

    @Override
    public TypedStreamWriter getLogStreamWriter() {
        return this.logStreamWriter;
    }

    @Override
    public Map<ValueType, UnifiedRecordValue> getEventCache() {
        return this.eventCache;
    }

    @Override
    public RecordProcessorMap getRecordProcessorMap() {
        return this.recordProcessorMap;
    }

    @Override
    public ZeebeState getZeebeState() {
        return this.zeebeState;
    }

    @Override
    public DbContext getDbContext() {
        return this.dbContext;
    }

    @Override
    public CommandResponseWriter getCommandResponseWriter() {
        return this.commandResponseWriter;
    }

    @Override
    public BooleanSupplier getAbortCondition() {
        return this.abortCondition;
    }

    @Override
    public MetricsManager getMetricsManager() {
        return this.metricsManager;
    }
}

