/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor;

import io.zeebe.util.metrics.Metric;
import io.zeebe.util.metrics.MetricsManager;

public class SnapshotMetrics {
    private final Metric snapshotSizeMetric;
    private final Metric snapshotTimeMillisMetric;

    public SnapshotMetrics(MetricsManager metricsManager, String processorName, String partitionId) {
        this.snapshotSizeMetric = metricsManager.newMetric("streamprocessor_snapshot_last_size_bytes").type("gauge").label("processor", processorName).label("partition", partitionId).create();
        this.snapshotTimeMillisMetric = metricsManager.newMetric("streamprocessor_snapshot_last_duration_millis").type("gauge").label("processor", processorName).label("partition", partitionId).create();
    }

    public void close() {
        this.snapshotTimeMillisMetric.close();
        this.snapshotSizeMetric.close();
    }

    public void recordSnapshotSize(long size) {
        this.snapshotSizeMetric.setOrdered(size);
    }

    public void recordSnapshotCreationTime(long creationTime) {
        this.snapshotTimeMillisMetric.setOrdered(creationTime);
    }
}

