/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor;

import io.zeebe.db.DbContext;
import io.zeebe.db.ZeebeDb;
import io.zeebe.engine.processor.ProcessingContext;
import io.zeebe.engine.processor.ProcessingStateMachine;
import io.zeebe.engine.processor.ReProcessingStateMachine;
import io.zeebe.engine.processor.RecordProcessorMap;
import io.zeebe.engine.processor.StreamProcessorBuilder;
import io.zeebe.engine.processor.StreamProcessorLifecycleAware;
import io.zeebe.engine.processor.StreamProcessorMetrics;
import io.zeebe.engine.processor.TypedEventRegistry;
import io.zeebe.engine.processor.TypedRecordProcessorFactory;
import io.zeebe.engine.processor.TypedRecordProcessors;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.logstreams.impl.Loggers;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceStartContext;
import io.zeebe.servicecontainer.ServiceStopContext;
import io.zeebe.util.LangUtil;
import io.zeebe.util.ReflectUtil;
import io.zeebe.util.metrics.MetricsManager;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorCondition;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class StreamProcessor
extends Actor
implements Service<StreamProcessor> {
    private static final String ERROR_MESSAGE_RECOVER_FROM_SNAPSHOT_FAILED = "Expected to find event with the snapshot position %s in log stream, but nothing was found. Failed to recover '%s'.";
    private static final Logger LOG = Loggers.LOGSTREAMS_LOGGER;
    private final ActorScheduler actorScheduler;
    private final AtomicBoolean isOpened = new AtomicBoolean(false);
    private final List<StreamProcessorLifecycleAware> lifecycleAwareListeners;
    private final LogStream logStream;
    private final int partitionId;
    private ActorCondition onCommitPositionUpdatedCondition;
    private final ZeebeDb zeebeDb;
    private long snapshotPosition = -1L;
    private final ProcessingContext processingContext;
    private StreamProcessorMetrics metrics;
    private final TypedRecordProcessorFactory typedRecordProcessorFactory;
    private final LogStreamReader logStreamReader;
    private ProcessingStateMachine processingStateMachine;
    private Phase phase = Phase.REPROCESSING;

    protected StreamProcessor(StreamProcessorBuilder context) {
        this.actorScheduler = context.getActorScheduler();
        this.lifecycleAwareListeners = context.getLifecycleListeners();
        this.typedRecordProcessorFactory = context.getTypedRecordProcessorFactory();
        this.zeebeDb = context.getZeebeDb();
        EnumMap eventCache = new EnumMap(ValueType.class);
        TypedEventRegistry.EVENT_REGISTRY.forEach((t, c) -> {
            UnifiedRecordValue cfr_ignored_0 = (UnifiedRecordValue)eventCache.put((ValueType)t, ReflectUtil.newInstance((Class)c));
        });
        this.processingContext = context.getProcessingContext().eventCache(Collections.unmodifiableMap(eventCache)).actor(this.actor).abortCondition(this::isClosed);
        this.logStreamReader = this.processingContext.getLogStreamReader();
        this.logStream = this.processingContext.getLogStream();
        this.partitionId = this.logStream.getPartitionId();
    }

    public static StreamProcessorBuilder builder(int processorId, String name) {
        return new StreamProcessorBuilder(processorId, name);
    }

    public String getName() {
        return this.processingContext.getStreamProcessorName();
    }

    public StreamProcessor get() {
        return this;
    }

    public void start(ServiceStartContext startContext) {
        startContext.async(this.openAsync());
    }

    public void stop(ServiceStopContext stopContext) {
        stopContext.async(this.closeAsync());
    }

    public ActorFuture<Void> openAsync() {
        if (this.isOpened.compareAndSet(false, true)) {
            return this.actorScheduler.submitActor((Actor)this, true);
        }
        return CompletableActorFuture.completed(null);
    }

    protected void onActorStarting() {
        MetricsManager metricsManager = this.actorScheduler.getMetricsManager();
        this.processingContext.metricsManager(metricsManager);
        this.metrics = new StreamProcessorMetrics(metricsManager, this.getName(), Integer.toString(this.partitionId));
    }

    protected void onActorStarted() {
        try {
            LOG.info("Recovering state of partition {} from snapshot", (Object)this.partitionId);
            this.snapshotPosition = this.recoverFromSnapshot();
            this.initProcessors();
            this.lifecycleAwareListeners.forEach(l -> l.onOpen(this.processingContext));
        }
        catch (Throwable e) {
            this.onFailure();
            LangUtil.rethrowUnchecked((Throwable)e);
        }
        try {
            this.processingStateMachine = new ProcessingStateMachine(this.processingContext, this.metrics, this::isOpened);
            ReProcessingStateMachine reProcessingStateMachine = new ReProcessingStateMachine(this.processingContext);
            ActorFuture<Void> recoverFuture = reProcessingStateMachine.startRecover(this.snapshotPosition);
            this.actor.runOnCompletion(recoverFuture, (v, throwable) -> {
                if (throwable != null) {
                    LOG.error("Unexpected error on recovery happens.", throwable);
                    this.onFailure();
                } else {
                    this.onRecovered();
                }
            });
        }
        catch (RuntimeException e) {
            this.onFailure();
            throw e;
        }
    }

    private void initProcessors() {
        TypedRecordProcessors typedRecordProcessors = this.typedRecordProcessorFactory.createProcessors(this.processingContext);
        this.lifecycleAwareListeners.addAll(typedRecordProcessors.getLifecycleListeners());
        RecordProcessorMap recordProcessorMap = typedRecordProcessors.getRecordProcessorMap();
        recordProcessorMap.values().forEachRemaining(this.lifecycleAwareListeners::add);
        this.processingContext.recordProcessorMap(recordProcessorMap);
    }

    private long recoverFromSnapshot() {
        boolean failedToRecoverReader;
        ZeebeState zeebeState = this.recoverState();
        long snapshotPosition = zeebeState.getLastSuccessfulProcessedRecordPosition();
        boolean bl = failedToRecoverReader = !this.logStreamReader.seekToNextEvent(snapshotPosition);
        if (failedToRecoverReader) {
            throw new IllegalStateException(String.format(ERROR_MESSAGE_RECOVER_FROM_SNAPSHOT_FAILED, snapshotPosition, this.getName()));
        }
        LOG.info("Recovered state of partition {} from snapshot at position {}", (Object)this.partitionId, (Object)snapshotPosition);
        return snapshotPosition;
    }

    private ZeebeState recoverState() {
        DbContext dbContext = this.zeebeDb.createContext();
        ZeebeState zeebeState = new ZeebeState(this.partitionId, (ZeebeDb<ZbColumnFamilies>)this.zeebeDb, dbContext);
        this.processingContext.dbContext(dbContext);
        this.processingContext.zeebeState(zeebeState);
        return zeebeState;
    }

    private void onRecovered() {
        this.phase = Phase.PROCESSING;
        this.onCommitPositionUpdatedCondition = this.actor.onCondition(this.getName() + "-on-commit-position-updated", this.processingStateMachine::readNextEvent);
        this.logStream.registerOnCommitPositionUpdatedCondition(this.onCommitPositionUpdatedCondition);
        this.lifecycleAwareListeners.forEach(l -> l.onRecovered(this.processingContext));
        this.actor.submit(this.processingStateMachine::readNextEvent);
    }

    public ActorFuture<Void> closeAsync() {
        if (this.isOpened.compareAndSet(true, false)) {
            return this.actor.close();
        }
        return CompletableActorFuture.completed(null);
    }

    protected void onActorCloseRequested() {
        if (!this.isFailed()) {
            this.lifecycleAwareListeners.forEach(StreamProcessorLifecycleAware::onClose);
        }
    }

    protected void onActorClosing() {
        this.metrics.close();
        this.processingContext.getLogStreamReader().close();
        if (this.onCommitPositionUpdatedCondition != null) {
            this.logStream.removeOnCommitPositionUpdatedCondition(this.onCommitPositionUpdatedCondition);
            this.onCommitPositionUpdatedCondition = null;
        }
    }

    protected void onActorClosed() {
        LOG.debug("Closed stream processor controller {}.", (Object)this.getName());
    }

    private void onFailure() {
        this.phase = Phase.FAILED;
        this.isOpened.set(false);
        this.actor.close();
    }

    public boolean isOpened() {
        return this.isOpened.get();
    }

    public boolean isClosed() {
        return !this.isOpened.get();
    }

    public boolean isFailed() {
        return this.phase == Phase.FAILED;
    }

    public ActorFuture<Long> getLastProcessedPositionAsync() {
        return this.actor.call(this.processingStateMachine::getLastSuccessfulProcessedEventPosition);
    }

    public ActorFuture<Long> getLastWrittenPositionAsync() {
        return this.actor.call(this.processingStateMachine::getLastWrittenEventPosition);
    }

    public StreamProcessorMetrics getMetrics() {
        return this.metrics;
    }

    private static enum Phase {
        REPROCESSING,
        PROCESSING,
        FAILED;

    }
}

