/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor;

import io.zeebe.db.ZeebeDb;
import io.zeebe.engine.processor.CommandResponseWriter;
import io.zeebe.engine.processor.EventFilter;
import io.zeebe.engine.processor.MetadataFilter;
import io.zeebe.engine.processor.ProcessingContext;
import io.zeebe.engine.processor.StreamProcessor;
import io.zeebe.engine.processor.StreamProcessorLifecycleAware;
import io.zeebe.engine.processor.StreamProcessorServiceNames;
import io.zeebe.engine.processor.TypedRecordProcessorFactory;
import io.zeebe.engine.processor.TypedStreamWriterImpl;
import io.zeebe.logstreams.impl.service.LogStreamServiceNames;
import io.zeebe.logstreams.log.BufferedLogStreamReader;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamReader;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.servicecontainer.Service;
import io.zeebe.servicecontainer.ServiceBuilder;
import io.zeebe.servicecontainer.ServiceContainer;
import io.zeebe.servicecontainer.ServiceName;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StreamProcessorBuilder {
    private TypedRecordProcessorFactory typedRecordProcessorFactory;
    private final ProcessingContext processingContext;
    private ActorScheduler actorScheduler;
    private ServiceContainer serviceContainer;
    private final List<ServiceName<?>> additionalDependencies = new ArrayList();
    private final List<StreamProcessorLifecycleAware> lifecycleListeners = new ArrayList<StreamProcessorLifecycleAware>();
    private ZeebeDb zeebeDb;

    public StreamProcessorBuilder(int id, String name) {
        Objects.requireNonNull(name);
        this.processingContext = new ProcessingContext().producerId(id).streamProcessorName(name);
    }

    public StreamProcessorBuilder streamProcessorFactory(TypedRecordProcessorFactory typedRecordProcessorFactory) {
        this.typedRecordProcessorFactory = typedRecordProcessorFactory;
        return this;
    }

    public StreamProcessorBuilder additionalDependencies(ServiceName<?> additionalDependencies) {
        this.additionalDependencies.add(additionalDependencies);
        return this;
    }

    public StreamProcessorBuilder actorScheduler(ActorScheduler actorScheduler) {
        this.actorScheduler = actorScheduler;
        return this;
    }

    public StreamProcessorBuilder serviceContainer(ServiceContainer serviceContainer) {
        this.serviceContainer = serviceContainer;
        return this;
    }

    public StreamProcessorBuilder logStream(LogStream stream) {
        this.processingContext.logStream(stream);
        return this;
    }

    public StreamProcessorBuilder eventFilter(EventFilter eventFilter) {
        this.processingContext.eventFilter(eventFilter);
        return this;
    }

    public StreamProcessorBuilder commandResponseWriter(CommandResponseWriter commandResponseWriter) {
        this.processingContext.commandResponseWriter(commandResponseWriter);
        return this;
    }

    public StreamProcessorBuilder zeebeDb(ZeebeDb zeebeDb) {
        this.zeebeDb = zeebeDb;
        return this;
    }

    public TypedRecordProcessorFactory getTypedRecordProcessorFactory() {
        return this.typedRecordProcessorFactory;
    }

    public ProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    public ActorScheduler getActorScheduler() {
        return this.actorScheduler;
    }

    public ServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    public List<StreamProcessorLifecycleAware> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    public ZeebeDb getZeebeDb() {
        return this.zeebeDb;
    }

    public ActorFuture<StreamProcessor> build() {
        this.validate();
        LogStream logStream = this.processingContext.getLogStream();
        this.processingContext.logStreamReader((LogStreamReader)new BufferedLogStreamReader(logStream)).logStreamWriter(new TypedStreamWriterImpl(logStream));
        VersionFilter metadataFilter = new VersionFilter();
        MetadataEventFilter eventFilter = new MetadataEventFilter(metadataFilter);
        this.processingContext.eventFilter(eventFilter);
        StreamProcessor streamProcessor = new StreamProcessor(this);
        String streamProcessorName = this.processingContext.getStreamProcessorName();
        String logName = logStream.getLogName();
        ServiceName<StreamProcessor> serviceName = StreamProcessorServiceNames.streamProcessorService(logName, streamProcessorName);
        ServiceBuilder serviceBuilder = this.serviceContainer.createService(serviceName, (Service)streamProcessor).dependency(LogStreamServiceNames.logStreamServiceName((String)logName)).dependency(LogStreamServiceNames.logWriteBufferServiceName((String)logName)).dependency(LogStreamServiceNames.logStorageServiceName((String)logName)).dependency(LogStreamServiceNames.logBlockIndexServiceName((String)logName));
        if (this.additionalDependencies != null) {
            this.additionalDependencies.forEach(d -> serviceBuilder.dependency(d));
        }
        return serviceBuilder.install();
    }

    private void validate() {
        Objects.requireNonNull(this.typedRecordProcessorFactory, "No stream processor factory provided.");
        Objects.requireNonNull(this.actorScheduler, "No task scheduler provided.");
        Objects.requireNonNull(this.serviceContainer, "No service container provided.");
        Objects.requireNonNull(this.processingContext.getLogStream(), "No log stream provided.");
        Objects.requireNonNull(this.processingContext.getCommandResponseWriter(), "No command response writer provided.");
        Objects.requireNonNull(this.zeebeDb, "No database provided.");
    }

    private final class VersionFilter
    implements MetadataFilter {
        private VersionFilter() {
        }

        @Override
        public boolean applies(RecordMetadata m) {
            if (m.getProtocolVersion() > 1) {
                throw new RuntimeException(String.format("Cannot handle event with version newer than what is implemented by broker (%d > %d)", m.getProtocolVersion(), 1));
            }
            return true;
        }
    }

    private static class MetadataEventFilter
    implements EventFilter {
        protected final RecordMetadata metadata = new RecordMetadata();
        protected final MetadataFilter metadataFilter;

        MetadataEventFilter(MetadataFilter metadataFilter) {
            this.metadataFilter = metadataFilter;
        }

        @Override
        public boolean applies(LoggedEvent event) {
            event.readMetadata((BufferReader)this.metadata);
            return this.metadataFilter.applies(this.metadata);
        }
    }
}

