/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor;

import io.zeebe.util.metrics.Metric;
import io.zeebe.util.metrics.MetricsManager;

public class StreamProcessorMetrics {
    private final Metric eventsProcessedCountMetric;
    private final Metric eventsWrittenCountMetric;
    private final Metric eventsSkippedCountMetric;

    public StreamProcessorMetrics(MetricsManager metricsManager, String processorName, String partitionId) {
        this.eventsProcessedCountMetric = metricsManager.newMetric("streamprocessor_events_count").type("counter").label("processor", processorName).label("action", "processed").label("partition", partitionId).create();
        this.eventsWrittenCountMetric = metricsManager.newMetric("streamprocessor_events_count").type("counter").label("processor", processorName).label("action", "written").label("partition", partitionId).create();
        this.eventsSkippedCountMetric = metricsManager.newMetric("streamprocessor_events_count").type("counter").label("processor", processorName).label("action", "skipped").label("partition", partitionId).create();
    }

    public void close() {
        this.eventsProcessedCountMetric.close();
        this.eventsSkippedCountMetric.close();
        this.eventsWrittenCountMetric.close();
    }

    public void incrementEventsProcessedCount() {
        this.eventsProcessedCountMetric.incrementOrdered();
    }

    public void incrementEventsSkippedCount() {
        this.eventsSkippedCountMetric.incrementOrdered();
    }

    public void incrementEventsWrittenCount() {
        this.eventsWrittenCountMetric.incrementOrdered();
    }
}

