/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor;

import io.zeebe.engine.processor.TypedCommandWriter;
import io.zeebe.engine.processor.TypedEventRegistry;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamBatchWriter;
import io.zeebe.logstreams.log.LogStreamBatchWriterImpl;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.util.buffer.BufferWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class TypedCommandWriterImpl
implements TypedCommandWriter {
    protected final Consumer<RecordMetadata> noop = m -> {};
    protected RecordMetadata metadata = new RecordMetadata();
    protected final Map<Class<? extends UnpackedObject>, ValueType> typeRegistry;
    protected final LogStream stream;
    protected LogStreamBatchWriter batchWriter;
    protected int producerId;
    protected long sourceRecordPosition = -1L;

    public TypedCommandWriterImpl(LogStream stream) {
        this.stream = stream;
        this.metadata.protocolVersion(1);
        this.batchWriter = new LogStreamBatchWriterImpl(stream);
        this.typeRegistry = new HashMap<Class<? extends UnpackedObject>, ValueType>();
        TypedEventRegistry.EVENT_REGISTRY.forEach((e, c) -> this.typeRegistry.put((Class<? extends UnpackedObject>)c, (ValueType)e));
    }

    public void configureSourceContext(int producerId, long sourceRecordPosition) {
        this.producerId = producerId;
        this.sourceRecordPosition = sourceRecordPosition;
    }

    protected void initMetadata(RecordType type, Intent intent, UnpackedObject value) {
        this.metadata.reset();
        ValueType valueType = this.typeRegistry.get(value.getClass());
        if (valueType == null) {
            throw new RuntimeException("Missing value type mapping for record: " + value.getClass());
        }
        this.metadata.partitionId(this.stream.getPartitionId()).recordType(type).valueType(valueType).intent(intent);
    }

    protected void appendRecord(long key, RecordType type, Intent intent, UnpackedObject value, Consumer<RecordMetadata> additionalMetadata) {
        this.appendRecord(key, type, intent, RejectionType.NULL_VAL, "", value, additionalMetadata);
    }

    protected void appendRecord(long key, RecordType type, Intent intent, RejectionType rejectionType, String rejectionReason, UnpackedObject value, Consumer<RecordMetadata> additionalMetadata) {
        LogStreamBatchWriter.LogEntryBuilder event = this.batchWriter.event();
        this.batchWriter.producerId(this.producerId);
        if (this.sourceRecordPosition >= 0L) {
            this.batchWriter.sourceRecordPosition(this.sourceRecordPosition);
        }
        this.initMetadata(type, intent, value);
        this.metadata.rejectionType(rejectionType);
        this.metadata.rejectionReason(rejectionReason);
        additionalMetadata.accept(this.metadata);
        if (key >= 0L) {
            event.key(key);
        } else {
            event.keyNull();
        }
        event.metadataWriter((BufferWriter)this.metadata).valueWriter((BufferWriter)value).done();
    }

    @Override
    public void appendNewCommand(Intent intent, UnpackedObject value) {
        this.appendRecord(-1L, RecordType.COMMAND, intent, value, this.noop);
    }

    @Override
    public void appendFollowUpCommand(long key, Intent intent, UnpackedObject value) {
        this.appendRecord(key, RecordType.COMMAND, intent, value, this.noop);
    }

    @Override
    public void appendFollowUpCommand(long key, Intent intent, UnpackedObject value, Consumer<RecordMetadata> metadata) {
        this.appendRecord(key, RecordType.COMMAND, intent, value, metadata);
    }

    @Override
    public void reset() {
        this.batchWriter.reset();
    }

    @Override
    public long flush() {
        return this.batchWriter.tryWrite();
    }
}

