/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor;

import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.logstreams.log.LoggedEvent;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import java.time.Instant;

public class TypedEventImpl
implements TypedRecord {
    protected LoggedEvent rawEvent;
    protected RecordMetadata metadata;
    protected UnifiedRecordValue value;

    public void wrap(LoggedEvent rawEvent, RecordMetadata metadata, UnifiedRecordValue value) {
        this.rawEvent = rawEvent;
        this.metadata = metadata;
        this.value = value;
    }

    @Override
    public int getMaxValueLength() {
        return this.rawEvent.getMaxValueLength();
    }

    public long getPosition() {
        return this.rawEvent.getPosition();
    }

    @Override
    public long getKey() {
        return this.rawEvent.getKey();
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    public UnifiedRecordValue getValue() {
        return this.value;
    }

    public String toString() {
        return "TypedEventImpl{metadata=" + this.metadata + ", value=" + this.value + '}';
    }

    public long getSourceRecordPosition() {
        return this.rawEvent.getSourceEventPosition();
    }

    public int getProducerId() {
        return this.rawEvent.getProducerId();
    }

    public Instant getTimestamp() {
        return Instant.ofEpochMilli(this.rawEvent.getTimestamp());
    }

    public String toJson() {
        StringBuilder builder = new StringBuilder();
        this.value.writeJSON(builder);
        return builder.toString();
    }
}

