/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor;

import io.zeebe.engine.processor.CommandProcessor;
import io.zeebe.engine.processor.CommandProcessorImpl;
import io.zeebe.engine.processor.RecordProcessorMap;
import io.zeebe.engine.processor.StreamProcessorLifecycleAware;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import java.util.ArrayList;
import java.util.List;

public final class TypedRecordProcessors {
    private final RecordProcessorMap recordProcessorMap = new RecordProcessorMap();
    private final List<StreamProcessorLifecycleAware> lifecycleListeners = new ArrayList<StreamProcessorLifecycleAware>();

    private TypedRecordProcessors() {
    }

    public static TypedRecordProcessors processors() {
        return new TypedRecordProcessors();
    }

    public TypedRecordProcessors onEvent(ValueType valueType, Intent intent, TypedRecordProcessor<?> processor) {
        return this.onRecord(RecordType.EVENT, valueType, intent, processor);
    }

    private TypedRecordProcessors onRecord(RecordType recordType, ValueType valueType, Intent intent, TypedRecordProcessor<?> processor) {
        this.recordProcessorMap.put(recordType, valueType, intent.value(), processor);
        return this;
    }

    public TypedRecordProcessors onCommand(ValueType valueType, Intent intent, TypedRecordProcessor<?> processor) {
        return this.onRecord(RecordType.COMMAND, valueType, intent, processor);
    }

    public <T extends UnifiedRecordValue> TypedRecordProcessors onCommand(ValueType valueType, Intent intent, CommandProcessor<T> commandProcessor) {
        return this.onCommand(valueType, intent, new CommandProcessorImpl<T>(commandProcessor));
    }

    public TypedRecordProcessors withListener(StreamProcessorLifecycleAware listener) {
        this.lifecycleListeners.add(listener);
        return this;
    }

    public RecordProcessorMap getRecordProcessorMap() {
        return this.recordProcessorMap;
    }

    public List<StreamProcessorLifecycleAware> getLifecycleListeners() {
        return this.lifecycleListeners;
    }
}

