/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor;

import io.zeebe.engine.processor.CommandResponseWriter;
import io.zeebe.engine.processor.SideEffectProducer;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.util.buffer.BufferWriter;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class TypedResponseWriterImpl
implements TypedResponseWriter,
SideEffectProducer {
    protected CommandResponseWriter writer;
    private long requestId;
    private int requestStreamId;
    private boolean isResponseStaged;
    protected int partitionId;
    private final UnsafeBuffer stringWrapper = new UnsafeBuffer(0L, 0);

    public TypedResponseWriterImpl(CommandResponseWriter writer, int partitionId) {
        this.writer = writer;
        this.partitionId = partitionId;
    }

    @Override
    public void writeRejectionOnCommand(TypedRecord<?> command, RejectionType type, String reason) {
        byte[] bytes = reason.getBytes(StandardCharsets.UTF_8);
        this.stringWrapper.wrap(bytes);
        this.stage(RecordType.COMMAND_REJECTION, command.getMetadata().getIntent(), command.getKey(), type, (DirectBuffer)this.stringWrapper, command.getMetadata(), (UnpackedObject)command.getValue());
    }

    @Override
    public void writeEvent(TypedRecord<?> event) {
        this.stringWrapper.wrap(0L, 0);
        this.stage(RecordType.EVENT, event.getMetadata().getIntent(), event.getKey(), RejectionType.NULL_VAL, (DirectBuffer)this.stringWrapper, event.getMetadata(), (UnpackedObject)event.getValue());
    }

    @Override
    public void writeEventOnCommand(long eventKey, Intent eventState, UnpackedObject eventValue, TypedRecord<?> command) {
        this.stringWrapper.wrap(0L, 0);
        this.stage(RecordType.EVENT, eventState, eventKey, RejectionType.NULL_VAL, (DirectBuffer)this.stringWrapper, command.getMetadata(), eventValue);
    }

    private void stage(RecordType type, Intent intent, long key, RejectionType rejectionType, DirectBuffer rejectionReason, RecordMetadata metadata, UnpackedObject value) {
        this.writer.partitionId(this.partitionId).key(key).intent(intent).recordType(type).valueType(metadata.getValueType()).rejectionType(rejectionType).rejectionReason(rejectionReason).valueWriter((BufferWriter)value);
        this.requestId = metadata.getRequestId();
        this.requestStreamId = metadata.getRequestStreamId();
        this.isResponseStaged = true;
    }

    public void reset() {
        this.isResponseStaged = false;
    }

    @Override
    public boolean flush() {
        if (this.isResponseStaged) {
            return this.writer.tryWriteResponse(this.requestStreamId, this.requestId);
        }
        return true;
    }
}

