/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow;

import io.zeebe.engine.processor.TypedCommandWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.EventOutput;
import io.zeebe.engine.processor.workflow.SideEffectQueue;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowElement;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.ElementInstanceState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.msgpack.mapping.MsgPackMergeTool;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.value.ErrorType;

public class BpmnStepContext<T extends ExecutableFlowElement> {
    private final IncidentRecord incidentCommand = new IncidentRecord();
    private final SideEffectQueue sideEffect = new SideEffectQueue();
    private final EventOutput eventOutput;
    private final MsgPackMergeTool mergeTool;
    private final WorkflowState stateDb;
    private long key;
    private WorkflowInstanceIntent intent;
    private WorkflowInstanceRecord recordValue;
    private ExecutableFlowElement element;
    private TypedCommandWriter commandWriter;

    public BpmnStepContext(WorkflowState stateDb, EventOutput eventOutput) {
        this.stateDb = stateDb;
        this.eventOutput = eventOutput;
        this.mergeTool = new MsgPackMergeTool(4096);
    }

    public WorkflowInstanceRecord getValue() {
        return this.recordValue;
    }

    public WorkflowInstanceIntent getState() {
        return this.intent;
    }

    public long getKey() {
        return this.key;
    }

    public void init(long key, WorkflowInstanceRecord recordValue, WorkflowInstanceIntent intent) {
        this.recordValue = recordValue;
        this.key = key;
        this.intent = intent;
    }

    public T getElement() {
        return (T)this.element;
    }

    public void setElement(ExecutableFlowElement element) {
        this.element = element;
    }

    public EventOutput getOutput() {
        return this.eventOutput;
    }

    public void setStreamWriter(TypedStreamWriter streamWriter) {
        this.eventOutput.setStreamWriter(streamWriter);
        this.commandWriter = streamWriter;
    }

    public MsgPackMergeTool getMergeTool() {
        return this.mergeTool;
    }

    public TypedCommandWriter getCommandWriter() {
        return this.commandWriter;
    }

    public ElementInstance getFlowScopeInstance() {
        WorkflowInstanceRecord value = this.getValue();
        return this.stateDb.getElementInstanceState().getInstance(value.getFlowScopeKey());
    }

    public ElementInstance getElementInstance() {
        if (this.recordValue != null) {
            return this.stateDb.getElementInstanceState().getInstance(this.key);
        }
        return null;
    }

    public SideEffectQueue getSideEffect() {
        return this.sideEffect;
    }

    public void raiseIncident(ErrorType errorType, String errorMessage) {
        this.raiseIncident(errorType, this.key, errorMessage);
    }

    public void raiseIncident(ErrorType errorType, long variableScopeKey, String errorMessage) {
        this.incidentCommand.reset();
        this.incidentCommand.initFromWorkflowInstanceFailure(this.key, this.recordValue).setErrorType(errorType).setErrorMessage(errorMessage).setVariableScopeKey(variableScopeKey);
        this.eventOutput.storeFailedRecord(this.key, this.recordValue, this.intent);
        this.commandWriter.appendNewCommand((Intent)IncidentIntent.CREATE, (UnpackedObject)this.incidentCommand);
    }

    public WorkflowState getStateDb() {
        return this.stateDb;
    }

    public ElementInstanceState getElementInstanceState() {
        return this.stateDb.getElementInstanceState();
    }
}

