/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow;

import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.BpmnStepHandler;
import io.zeebe.engine.processor.workflow.CatchEventBehavior;
import io.zeebe.engine.processor.workflow.deployment.model.BpmnStep;
import io.zeebe.engine.processor.workflow.handlers.CatchEventSubscriber;
import io.zeebe.engine.processor.workflow.handlers.IncidentResolver;
import io.zeebe.engine.processor.workflow.handlers.activity.ActivityElementActivatingHandler;
import io.zeebe.engine.processor.workflow.handlers.activity.ActivityElementCompletingHandler;
import io.zeebe.engine.processor.workflow.handlers.activity.ActivityElementTerminatedHandler;
import io.zeebe.engine.processor.workflow.handlers.activity.ActivityElementTerminatingHandler;
import io.zeebe.engine.processor.workflow.handlers.activity.ActivityEventOccurredHandler;
import io.zeebe.engine.processor.workflow.handlers.catchevent.IntermediateCatchEventElementActivatedHandler;
import io.zeebe.engine.processor.workflow.handlers.catchevent.IntermediateCatchEventElementActivatingHandler;
import io.zeebe.engine.processor.workflow.handlers.catchevent.IntermediateCatchEventElementCompletingHandler;
import io.zeebe.engine.processor.workflow.handlers.catchevent.IntermediateCatchEventElementTerminatingHandler;
import io.zeebe.engine.processor.workflow.handlers.catchevent.IntermediateCatchEventEventOccurredHandler;
import io.zeebe.engine.processor.workflow.handlers.catchevent.StartEventEventOccurredHandler;
import io.zeebe.engine.processor.workflow.handlers.container.ContainerElementActivatedHandler;
import io.zeebe.engine.processor.workflow.handlers.container.ContainerElementTerminatingHandler;
import io.zeebe.engine.processor.workflow.handlers.element.ElementActivatedHandler;
import io.zeebe.engine.processor.workflow.handlers.element.ElementActivatingHandler;
import io.zeebe.engine.processor.workflow.handlers.element.ElementCompletedHandler;
import io.zeebe.engine.processor.workflow.handlers.element.ElementCompletingHandler;
import io.zeebe.engine.processor.workflow.handlers.element.ElementTerminatedHandler;
import io.zeebe.engine.processor.workflow.handlers.element.ElementTerminatingHandler;
import io.zeebe.engine.processor.workflow.handlers.element.EventOccurredHandler;
import io.zeebe.engine.processor.workflow.handlers.gateway.EventBasedGatewayElementActivatingHandler;
import io.zeebe.engine.processor.workflow.handlers.gateway.EventBasedGatewayElementCompletedHandler;
import io.zeebe.engine.processor.workflow.handlers.gateway.EventBasedGatewayElementCompletingHandler;
import io.zeebe.engine.processor.workflow.handlers.gateway.EventBasedGatewayElementTerminatingHandler;
import io.zeebe.engine.processor.workflow.handlers.gateway.EventBasedGatewayEventOccurredHandler;
import io.zeebe.engine.processor.workflow.handlers.gateway.ExclusiveGatewayElementActivatingHandler;
import io.zeebe.engine.processor.workflow.handlers.receivetask.ReceiveTaskEventOccurredHandler;
import io.zeebe.engine.processor.workflow.handlers.seqflow.FlowOutElementCompletedHandler;
import io.zeebe.engine.processor.workflow.handlers.seqflow.ParallelMergeSequenceFlowTaken;
import io.zeebe.engine.processor.workflow.handlers.seqflow.SequenceFlowTakenHandler;
import io.zeebe.engine.processor.workflow.handlers.servicetask.ServiceTaskElementActivatedHandler;
import io.zeebe.engine.processor.workflow.handlers.servicetask.ServiceTaskElementTerminatingHandler;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import java.util.EnumMap;
import java.util.Map;

public class BpmnStepHandlers {
    private final Map<BpmnStep, BpmnStepHandler<?>> stepHandlers = new EnumMap(BpmnStep.class);

    public BpmnStepHandlers(ZeebeState state, CatchEventBehavior catchEventBehavior) {
        IncidentResolver incidentResolver = new IncidentResolver(state.getIncidentState());
        CatchEventSubscriber catchEventSubscriber = new CatchEventSubscriber(catchEventBehavior);
        this.stepHandlers.put(BpmnStep.ELEMENT_ACTIVATING, new ElementActivatingHandler());
        this.stepHandlers.put(BpmnStep.ELEMENT_ACTIVATED, new ElementActivatedHandler());
        this.stepHandlers.put(BpmnStep.EVENT_OCCURRED, new EventOccurredHandler());
        this.stepHandlers.put(BpmnStep.ELEMENT_COMPLETING, new ElementCompletingHandler());
        this.stepHandlers.put(BpmnStep.ELEMENT_COMPLETED, new ElementCompletedHandler());
        this.stepHandlers.put(BpmnStep.ELEMENT_TERMINATING, new ElementTerminatingHandler());
        this.stepHandlers.put(BpmnStep.ELEMENT_TERMINATED, new ElementTerminatedHandler(incidentResolver));
        this.stepHandlers.put(BpmnStep.FLOWOUT_ELEMENT_COMPLETED, new FlowOutElementCompletedHandler());
        this.stepHandlers.put(BpmnStep.ACTIVITY_ELEMENT_ACTIVATING, new ActivityElementActivatingHandler(catchEventSubscriber));
        this.stepHandlers.put(BpmnStep.ACTIVITY_ELEMENT_ACTIVATED, new ElementActivatedHandler(null));
        this.stepHandlers.put(BpmnStep.ACTIVITY_EVENT_OCCURRED, new ActivityEventOccurredHandler());
        this.stepHandlers.put(BpmnStep.ACTIVITY_ELEMENT_COMPLETING, new ActivityElementCompletingHandler(catchEventSubscriber));
        this.stepHandlers.put(BpmnStep.ACTIVITY_ELEMENT_TERMINATING, new ActivityElementTerminatingHandler(catchEventSubscriber));
        this.stepHandlers.put(BpmnStep.ACTIVITY_ELEMENT_TERMINATED, new ActivityElementTerminatedHandler(incidentResolver));
        this.stepHandlers.put(BpmnStep.CONTAINER_ELEMENT_ACTIVATED, new ContainerElementActivatedHandler(state.getWorkflowState()));
        this.stepHandlers.put(BpmnStep.CONTAINER_ELEMENT_TERMINATING, new ContainerElementTerminatingHandler(catchEventSubscriber));
        this.stepHandlers.put(BpmnStep.EVENT_BASED_GATEWAY_ELEMENT_ACTIVATING, new EventBasedGatewayElementActivatingHandler(catchEventSubscriber));
        this.stepHandlers.put(BpmnStep.EVENT_BASED_GATEWAY_ELEMENT_ACTIVATED, new ElementActivatedHandler(null));
        this.stepHandlers.put(BpmnStep.EVENT_BASED_GATEWAY_EVENT_OCCURRED, new EventBasedGatewayEventOccurredHandler());
        this.stepHandlers.put(BpmnStep.EVENT_BASED_GATEWAY_ELEMENT_COMPLETING, new EventBasedGatewayElementCompletingHandler(catchEventSubscriber));
        this.stepHandlers.put(BpmnStep.EVENT_BASED_GATEWAY_ELEMENT_TERMINATING, new EventBasedGatewayElementTerminatingHandler(catchEventSubscriber));
        this.stepHandlers.put(BpmnStep.EVENT_BASED_GATEWAY_ELEMENT_COMPLETED, new EventBasedGatewayElementCompletedHandler());
        this.stepHandlers.put(BpmnStep.EXCLUSIVE_GATEWAY_ELEMENT_ACTIVATING, new ExclusiveGatewayElementActivatingHandler());
        this.stepHandlers.put(BpmnStep.EXCLUSIVE_GATEWAY_ELEMENT_COMPLETED, new EventBasedGatewayElementCompletedHandler());
        this.stepHandlers.put(BpmnStep.INTERMEDIATE_CATCH_EVENT_ELEMENT_ACTIVATING, new IntermediateCatchEventElementActivatingHandler(catchEventSubscriber));
        this.stepHandlers.put(BpmnStep.INTERMEDIATE_CATCH_EVENT_ELEMENT_ACTIVATED, new IntermediateCatchEventElementActivatedHandler());
        this.stepHandlers.put(BpmnStep.INTERMEDIATE_CATCH_EVENT_EVENT_OCCURRED, new IntermediateCatchEventEventOccurredHandler());
        this.stepHandlers.put(BpmnStep.INTERMEDIATE_CATCH_EVENT_ELEMENT_COMPLETING, new IntermediateCatchEventElementCompletingHandler(catchEventSubscriber));
        this.stepHandlers.put(BpmnStep.INTERMEDIATE_CATCH_EVENT_ELEMENT_TERMINATING, new IntermediateCatchEventElementTerminatingHandler(catchEventSubscriber));
        this.stepHandlers.put(BpmnStep.RECEIVE_TASK_EVENT_OCCURRED, new ReceiveTaskEventOccurredHandler());
        this.stepHandlers.put(BpmnStep.SERVICE_TASK_ELEMENT_ACTIVATED, new ServiceTaskElementActivatedHandler());
        this.stepHandlers.put(BpmnStep.SERVICE_TASK_ELEMENT_TERMINATING, new ServiceTaskElementTerminatingHandler(state.getIncidentState(), catchEventSubscriber, state.getJobState()));
        this.stepHandlers.put(BpmnStep.START_EVENT_EVENT_OCCURRED, new StartEventEventOccurredHandler(state));
        this.stepHandlers.put(BpmnStep.PARALLEL_MERGE_SEQUENCE_FLOW_TAKEN, new ParallelMergeSequenceFlowTaken());
        this.stepHandlers.put(BpmnStep.SEQUENCE_FLOW_TAKEN, new SequenceFlowTakenHandler());
    }

    public void handle(BpmnStepContext context) {
        WorkflowInstanceIntent state;
        Object flowElement = context.getElement();
        BpmnStep step = flowElement.getStep(state = context.getState());
        if (step != null) {
            BpmnStepHandler<?> stepHandler = this.stepHandlers.get((Object)step);
            assert (stepHandler != null) : "no step handler configured for step " + step.toString();
            stepHandler.handle(context);
        }
    }
}

