/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow;

import io.zeebe.engine.processor.SideEffectProducer;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.BpmnStepHandlers;
import io.zeebe.engine.processor.workflow.CatchEventBehavior;
import io.zeebe.engine.processor.workflow.EventOutput;
import io.zeebe.engine.processor.workflow.deployment.model.element.AbstractFlowElement;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.engine.state.deployment.DeployedWorkflow;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.WorkflowEngineState;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public class BpmnStepProcessor
implements TypedRecordProcessor<WorkflowInstanceRecord> {
    private final WorkflowEngineState state;
    private final BpmnStepHandlers stepHandlers;
    private final WorkflowState workflowState;
    private final BpmnStepContext context;

    public BpmnStepProcessor(WorkflowEngineState state, ZeebeState zeebeState, CatchEventBehavior catchEventBehavior) {
        this.state = state;
        this.workflowState = state.getWorkflowState();
        this.stepHandlers = new BpmnStepHandlers(zeebeState, catchEventBehavior);
        EventOutput eventOutput = new EventOutput(state, zeebeState.getKeyGenerator());
        this.context = new BpmnStepContext(this.workflowState, eventOutput);
    }

    @Override
    public void onClose() {
        this.state.onClose();
    }

    @Override
    public void processRecord(TypedRecord<WorkflowInstanceRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        this.processRecordValue(record.getKey(), record.getValue(), (WorkflowInstanceIntent)record.getMetadata().getIntent(), streamWriter, sideEffect);
    }

    public void processRecordValue(long key, WorkflowInstanceRecord recordValue, WorkflowInstanceIntent intent, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        this.populateEventContext(key, recordValue, intent, streamWriter, sideEffect);
        this.stepHandlers.handle(this.context);
    }

    private void populateEventContext(long key, WorkflowInstanceRecord recordValue, WorkflowInstanceIntent intent, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        this.context.init(key, recordValue, intent);
        this.context.setStreamWriter(streamWriter);
        this.context.getSideEffect().clear();
        sideEffect.accept(this.context.getSideEffect());
        long workflowKey = recordValue.getWorkflowKey();
        DeployedWorkflow deployedWorkflow = this.workflowState.getWorkflowByKey(workflowKey);
        if (deployedWorkflow == null) {
            throw new IllegalStateException("Error while processing workflow. Workflow with " + workflowKey + " is not deployed");
        }
        this.populateElementInContext(deployedWorkflow);
    }

    private void populateElementInContext(DeployedWorkflow deployedWorkflow) {
        WorkflowInstanceRecord value = this.context.getValue();
        DirectBuffer currentElementId = value.getElementIdBuffer();
        ExecutableWorkflow workflow = deployedWorkflow.getWorkflow();
        AbstractFlowElement flowElement = workflow.getElementById(currentElementId);
        this.context.setElement(flowElement);
    }
}

