/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow;

import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.BpmnStepContext;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableCatchEvent;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableCatchEventSupplier;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableMessage;
import io.zeebe.engine.processor.workflow.message.MessageCorrelationKeyContext;
import io.zeebe.engine.processor.workflow.message.MessageCorrelationKeyException;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.engine.state.instance.TimerInstance;
import io.zeebe.engine.state.message.WorkflowInstanceSubscription;
import io.zeebe.model.bpmn.util.time.Timer;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.msgpack.query.MsgPackQueryProcessor;
import io.zeebe.protocol.impl.SubscriptionUtil;
import io.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.TimerIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import io.zeebe.util.buffer.BufferUtil;
import io.zeebe.util.sched.clock.ActorClock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;

public class CatchEventBehavior {
    private final ZeebeState state;
    private final SubscriptionCommandSender subscriptionCommandSender;
    private final int partitionsCount;
    private final MsgPackQueryProcessor queryProcessor = new MsgPackQueryProcessor();
    private final WorkflowInstanceSubscription subscription = new WorkflowInstanceSubscription();
    private final TimerRecord timerRecord = new TimerRecord();
    private final Map<DirectBuffer, DirectBuffer> extractedCorrelationKeys = new HashMap<DirectBuffer, DirectBuffer>();

    public CatchEventBehavior(ZeebeState state, SubscriptionCommandSender subscriptionCommandSender, int partitionsCount) {
        this.state = state;
        this.subscriptionCommandSender = subscriptionCommandSender;
        this.partitionsCount = partitionsCount;
    }

    public void unsubscribeFromEvents(long elementInstanceKey, BpmnStepContext<?> context) {
        this.unsubscribeFromTimerEvents(elementInstanceKey, context.getOutput().getStreamWriter());
        this.unsubscribeFromMessageEvents(elementInstanceKey, context);
        context.getStateDb().getEventScopeInstanceState().deleteInstance(elementInstanceKey);
    }

    public void subscribeToEvents(BpmnStepContext<?> context, ExecutableCatchEventSupplier supplier) throws MessageCorrelationKeyException {
        List<ExecutableCatchEvent> events = supplier.getEvents();
        MessageCorrelationKeyContext.VariablesDocumentSupplier variablesSupplier = context.getElementInstanceState().getVariablesState()::getVariablesAsDocument;
        MessageCorrelationKeyContext elementContext = new MessageCorrelationKeyContext(variablesSupplier, context.getKey());
        MessageCorrelationKeyContext scopeContext = new MessageCorrelationKeyContext(variablesSupplier, context.getValue().getFlowScopeKey());
        Map<DirectBuffer, DirectBuffer> extractedCorrelationKeys = this.extractMessageCorrelationKeys(events, elementContext, scopeContext);
        for (ExecutableCatchEvent event : events) {
            if (event.isTimer()) {
                this.subscribeToTimerEvent(context.getKey(), context.getValue().getWorkflowInstanceKey(), context.getValue().getWorkflowKey(), event.getId(), event.getTimer(), context.getOutput().getStreamWriter());
                continue;
            }
            if (!event.isMessage()) continue;
            this.subscribeToMessageEvent(context, event, extractedCorrelationKeys.get(event.getId()));
        }
        context.getStateDb().getEventScopeInstanceState().createIfNotExists(context.getKey(), supplier.getInterruptingElementIds());
    }

    public void subscribeToTimerEvent(long elementInstanceKey, long workflowInstanceKey, long workflowKey, DirectBuffer handlerNodeId, Timer timer, TypedStreamWriter writer) {
        this.timerRecord.reset();
        this.timerRecord.setRepetitions(timer.getRepetitions()).setDueDate(timer.getDueDate(ActorClock.currentTimeMillis())).setElementInstanceKey(elementInstanceKey).setWorkflowInstanceKey(workflowInstanceKey).setHandlerNodeId(handlerNodeId).setWorkflowKey(workflowKey);
        writer.appendNewCommand((Intent)TimerIntent.CREATE, (UnpackedObject)this.timerRecord);
    }

    private void unsubscribeFromTimerEvents(long elementInstanceKey, TypedStreamWriter writer) {
        this.state.getWorkflowState().getTimerState().forEachTimerForElementInstance(elementInstanceKey, t -> this.unsubscribeFromTimerEvent((TimerInstance)t, writer));
    }

    public void unsubscribeFromTimerEvent(TimerInstance timer, TypedStreamWriter writer) {
        this.timerRecord.reset();
        this.timerRecord.setElementInstanceKey(timer.getElementInstanceKey()).setWorkflowInstanceKey(timer.getWorkflowInstanceKey()).setDueDate(timer.getDueDate()).setRepetitions(timer.getRepetitions()).setHandlerNodeId(timer.getHandlerNodeId()).setWorkflowKey(timer.getWorkflowKey());
        writer.appendFollowUpCommand(timer.getKey(), (Intent)TimerIntent.CANCEL, (UnpackedObject)this.timerRecord);
    }

    private void subscribeToMessageEvent(BpmnStepContext<?> context, ExecutableCatchEvent handler, DirectBuffer extractedKey) {
        ExecutableMessage message = handler.getMessage();
        long workflowInstanceKey = context.getValue().getWorkflowInstanceKey();
        long elementInstanceKey = context.getKey();
        DirectBuffer messageName = BufferUtil.cloneBuffer((DirectBuffer)message.getMessageName());
        DirectBuffer correlationKey = extractedKey;
        boolean closeOnCorrelate = handler.shouldCloseMessageSubscriptionOnCorrelate();
        int subscriptionPartitionId = SubscriptionUtil.getSubscriptionPartitionId((DirectBuffer)correlationKey, (int)this.partitionsCount);
        this.subscription.setSubscriptionPartitionId(subscriptionPartitionId);
        this.subscription.setMessageName(messageName);
        this.subscription.setElementInstanceKey(elementInstanceKey);
        this.subscription.setCommandSentTime(ActorClock.currentTimeMillis());
        this.subscription.setWorkflowInstanceKey(workflowInstanceKey);
        this.subscription.setCorrelationKey(correlationKey);
        this.subscription.setHandlerNodeId(handler.getId());
        this.subscription.setCloseOnCorrelate(closeOnCorrelate);
        this.state.getWorkflowInstanceSubscriptionState().put(this.subscription);
        context.getSideEffect().add(() -> this.sendOpenMessageSubscription(subscriptionPartitionId, workflowInstanceKey, elementInstanceKey, messageName, correlationKey, closeOnCorrelate));
    }

    private void unsubscribeFromMessageEvents(long elementInstanceKey, BpmnStepContext<?> context) {
        this.state.getWorkflowInstanceSubscriptionState().visitElementSubscriptions(elementInstanceKey, sub -> this.unsubscribeFromMessageEvent(context, sub));
    }

    private boolean unsubscribeFromMessageEvent(BpmnStepContext<?> context, WorkflowInstanceSubscription subscription) {
        DirectBuffer messageName = BufferUtil.cloneBuffer((DirectBuffer)subscription.getMessageName());
        int subscriptionPartitionId = subscription.getSubscriptionPartitionId();
        long workflowInstanceKey = subscription.getWorkflowInstanceKey();
        long elementInstanceKey = subscription.getElementInstanceKey();
        subscription.setClosing();
        this.state.getWorkflowInstanceSubscriptionState().updateToClosingState(subscription, ActorClock.currentTimeMillis());
        context.getSideEffect().add(() -> this.sendCloseMessageSubscriptionCommand(subscriptionPartitionId, workflowInstanceKey, elementInstanceKey, messageName));
        return true;
    }

    private DirectBuffer extractCorrelationKey(ExecutableMessage message, MessageCorrelationKeyContext context) {
        String errorMessage;
        MsgPackQueryProcessor.QueryResults results = this.queryProcessor.process(message.getCorrelationKey(), context.getVariablesAsDocument());
        if (results.size() == 1) {
            MsgPackQueryProcessor.QueryResult result = results.getSingleResult();
            if (result.isString()) {
                return result.getString();
            }
            if (result.isLong()) {
                return result.getLongAsString();
            }
            errorMessage = "the value must be either a string or a number";
        } else {
            errorMessage = results.size() > 1 ? "multiple values found" : "no value found";
        }
        String expression = BufferUtil.bufferAsString((DirectBuffer)message.getCorrelationKey().getExpression());
        String failureMessage = String.format("Failed to extract the correlation-key by '%s': %s", expression, errorMessage);
        throw new MessageCorrelationKeyException(context, failureMessage);
    }

    private boolean sendCloseMessageSubscriptionCommand(int subscriptionPartitionId, long workflowInstanceKey, long elementInstanceKey, DirectBuffer messageName) {
        return this.subscriptionCommandSender.closeMessageSubscription(subscriptionPartitionId, workflowInstanceKey, elementInstanceKey, messageName);
    }

    private boolean sendOpenMessageSubscription(int subscriptionPartitionId, long workflowInstanceKey, long elementInstanceKey, DirectBuffer messageName, DirectBuffer correlationKey, boolean closeOnCorrelate) {
        return this.subscriptionCommandSender.openMessageSubscription(subscriptionPartitionId, workflowInstanceKey, elementInstanceKey, messageName, correlationKey, closeOnCorrelate);
    }

    private Map<DirectBuffer, DirectBuffer> extractMessageCorrelationKeys(List<ExecutableCatchEvent> events, MessageCorrelationKeyContext elementContext, MessageCorrelationKeyContext scopeContext) {
        this.extractedCorrelationKeys.clear();
        for (ExecutableCatchEvent event : events) {
            if (!event.isMessage()) continue;
            MessageCorrelationKeyContext context = event.getElementType() == BpmnElementType.BOUNDARY_EVENT ? scopeContext : elementContext;
            DirectBuffer correlationKey = this.extractCorrelationKey(event.getMessage(), context);
            this.extractedCorrelationKeys.put(event.getId(), BufferUtil.cloneBuffer((DirectBuffer)correlationKey));
        }
        return this.extractedCorrelationKeys;
    }
}

