/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow;

import io.zeebe.engine.processor.ProcessingContext;
import io.zeebe.engine.processor.TypedRecordProcessors;
import io.zeebe.engine.processor.workflow.BpmnStepProcessor;
import io.zeebe.engine.processor.workflow.CatchEventBehavior;
import io.zeebe.engine.processor.workflow.WorkflowEventProcessors;
import io.zeebe.engine.processor.workflow.deployment.DeploymentCreatedProcessor;
import io.zeebe.engine.processor.workflow.deployment.DeploymentEventProcessors;
import io.zeebe.engine.processor.workflow.deployment.distribute.DeploymentDistributeProcessor;
import io.zeebe.engine.processor.workflow.deployment.distribute.DeploymentDistributor;
import io.zeebe.engine.processor.workflow.incident.IncidentEventProcessors;
import io.zeebe.engine.processor.workflow.job.JobEventProcessors;
import io.zeebe.engine.processor.workflow.message.MessageEventProcessors;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.processor.workflow.timer.DueDateTimerChecker;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamWriterImpl;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.Intent;

public class EngineProcessors {
    public static TypedRecordProcessors createEngineProcessors(ProcessingContext processingContext, int partitionsCount, SubscriptionCommandSender subscriptionCommandSender, DeploymentDistributor deploymentDistributor) {
        TypedRecordProcessors typedRecordProcessors = TypedRecordProcessors.processors();
        LogStream stream = processingContext.getLogStream();
        int partitionId = stream.getPartitionId();
        ZeebeState zeebeState = processingContext.getZeebeState();
        EngineProcessors.addDistributeDeploymentProcessors(zeebeState, stream, typedRecordProcessors, deploymentDistributor);
        CatchEventBehavior catchEventBehavior = new CatchEventBehavior(zeebeState, subscriptionCommandSender, partitionsCount);
        EngineProcessors.addDeploymentRelatedProcessorAndServices(catchEventBehavior, partitionId, zeebeState, typedRecordProcessors);
        EngineProcessors.addMessageProcessors(subscriptionCommandSender, zeebeState, typedRecordProcessors);
        BpmnStepProcessor stepProcessor = EngineProcessors.addWorkflowProcessors(zeebeState, typedRecordProcessors, subscriptionCommandSender, catchEventBehavior);
        EngineProcessors.addIncidentProcessors(zeebeState, stepProcessor, typedRecordProcessors);
        EngineProcessors.addJobProcessors(zeebeState, typedRecordProcessors);
        return typedRecordProcessors;
    }

    private static void addDistributeDeploymentProcessors(ZeebeState zeebeState, LogStream stream, TypedRecordProcessors typedRecordProcessors, DeploymentDistributor deploymentDistributor) {
        DeploymentDistributeProcessor deploymentDistributeProcessor = new DeploymentDistributeProcessor(zeebeState.getDeploymentState(), new LogStreamWriterImpl(stream), deploymentDistributor);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.DISTRIBUTE, deploymentDistributeProcessor);
    }

    private static BpmnStepProcessor addWorkflowProcessors(ZeebeState zeebeState, TypedRecordProcessors typedRecordProcessors, SubscriptionCommandSender subscriptionCommandSender, CatchEventBehavior catchEventBehavior) {
        DueDateTimerChecker timerChecker = new DueDateTimerChecker(zeebeState.getWorkflowState());
        return WorkflowEventProcessors.addWorkflowProcessors(zeebeState, typedRecordProcessors, subscriptionCommandSender, catchEventBehavior, timerChecker);
    }

    private static void addDeploymentRelatedProcessorAndServices(CatchEventBehavior catchEventBehavior, int partitionId, ZeebeState zeebeState, TypedRecordProcessors typedRecordProcessors) {
        boolean isDeploymentPartition;
        WorkflowState workflowState = zeebeState.getWorkflowState();
        boolean bl = isDeploymentPartition = partitionId == 1;
        if (isDeploymentPartition) {
            DeploymentEventProcessors.addTransformingDeploymentProcessor(typedRecordProcessors, zeebeState, catchEventBehavior);
        } else {
            DeploymentEventProcessors.addDeploymentCreateProcessor(typedRecordProcessors, workflowState);
        }
        typedRecordProcessors.onEvent(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATED, new DeploymentCreatedProcessor(workflowState, isDeploymentPartition));
    }

    private static void addIncidentProcessors(ZeebeState zeebeState, BpmnStepProcessor stepProcessor, TypedRecordProcessors typedRecordProcessors) {
        IncidentEventProcessors.addProcessors(typedRecordProcessors, zeebeState, stepProcessor);
    }

    private static void addJobProcessors(ZeebeState zeebeState, TypedRecordProcessors typedRecordProcessors) {
        JobEventProcessors.addJobProcessors(typedRecordProcessors, zeebeState);
    }

    private static void addMessageProcessors(SubscriptionCommandSender subscriptionCommandSender, ZeebeState zeebeState, TypedRecordProcessors typedRecordProcessors) {
        MessageEventProcessors.addMessageProcessors(typedRecordProcessors, zeebeState, subscriptionCommandSender);
    }
}

