/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow;

import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableFlowElement;
import io.zeebe.engine.state.instance.StoredRecord;
import io.zeebe.engine.state.instance.WorkflowEngineState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;

public class EventOutput {
    private final WorkflowEngineState materializedState;
    private final KeyGenerator keyGenerator;
    private TypedStreamWriter streamWriter;

    public EventOutput(WorkflowEngineState materializedState, KeyGenerator keyGenerator) {
        this.materializedState = materializedState;
        this.keyGenerator = keyGenerator;
    }

    public void setStreamWriter(TypedStreamWriter streamWriter) {
        this.streamWriter = streamWriter;
    }

    public long appendNewEvent(WorkflowInstanceIntent state, WorkflowInstanceRecord value) {
        return this.appendNewEvent(state, value, null);
    }

    public long appendNewEvent(WorkflowInstanceIntent state, WorkflowInstanceRecord value, ExecutableFlowElement element) {
        if (element != null) {
            value.setElementId(element.getId());
            value.setBpmnElementType(element.getElementType());
        }
        long key = this.keyGenerator.nextKey();
        this.streamWriter.appendNewEvent(key, (Intent)state, (UnpackedObject)value);
        this.materializedState.onEventProduced(key, state, value);
        return key;
    }

    public void appendFollowUpEvent(long key, WorkflowInstanceIntent state, WorkflowInstanceRecord value) {
        this.appendFollowUpEvent(key, state, value, null);
    }

    public void appendFollowUpEvent(long key, WorkflowInstanceIntent state, WorkflowInstanceRecord value, ExecutableFlowElement element) {
        if (element != null) {
            value.setElementId(element.getId());
            value.setBpmnElementType(element.getElementType());
        }
        this.streamWriter.appendFollowUpEvent(key, (Intent)state, (UnpackedObject)value);
        this.materializedState.onEventProduced(key, state, value);
    }

    public void appendResolvedIncidentEvent(long incidentKey, IncidentRecord incidentRecord) {
        this.streamWriter.appendFollowUpEvent(incidentKey, (Intent)IncidentIntent.RESOLVED, (UnpackedObject)incidentRecord);
    }

    public long deferEvent(WorkflowInstanceIntent intent, WorkflowInstanceRecord recordValue) {
        return this.deferRecord(recordValue.getFlowScopeKey(), recordValue, intent);
    }

    public long deferRecord(long scopeKey, WorkflowInstanceRecord value, WorkflowInstanceIntent intent) {
        long elementInstanceKey = this.keyGenerator.nextKey();
        this.materializedState.deferRecord(elementInstanceKey, scopeKey, value, intent);
        return elementInstanceKey;
    }

    public void removeDeferredEvent(long scopeKey, long key) {
        this.materializedState.removeStoredRecord(scopeKey, key, StoredRecord.Purpose.DEFERRED);
    }

    public TypedStreamWriter getStreamWriter() {
        return this.streamWriter;
    }

    public void storeFailedRecord(long key, WorkflowInstanceRecord recordValue, WorkflowInstanceIntent intent) {
        this.materializedState.storeFailedRecord(key, recordValue, intent);
    }
}

